/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class NullInjectedIntoNonNullableTest {
    @Before
    public void ensureStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void nullReturnedFromProvidesMethod() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new FromProvidesMethodModule()});
        ProvisionException exception = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> {
            Foo cfr_ignored_0 = (Foo)injector.getInstance(Foo.class);
        });
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "null_returned_from_provides_method.txt");
    }

    @Test
    public void nullReturnedFromProvider() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new FromProviderModule()});
        ProvisionException exception = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> {
            Foo cfr_ignored_0 = (Foo)injector.getInstance(Foo.class);
        });
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "null_returned_from_provider.txt");
    }

    @Test
    public void nullReturnedFromProviderWithModuleStack() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new IntermediateModule()});
        ProvisionException exception = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> {
            Foo cfr_ignored_0 = (Foo)injector.getInstance(Foo.class);
        });
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "null_returned_from_provider_with_module_stack.txt");
    }

    static class IntermediateModule
    extends AbstractModule {
        public static final String NULL = null;
        private static final Module MODULE = new AbstractModule(){

            protected void configure() {
                Field field = null;
                try {
                    field = IntermediateModule.class.getField("NULL");
                }
                catch (NoSuchFieldException error) {
                    throw new AssertionError((Object)"NULL field missing!");
                }
                this.binder().withSource((Object)field).bind(String.class).annotatedWith(Bar.class).toProvider(() -> NULL);
            }
        };

        IntermediateModule() {
        }

        protected void configure() {
            this.install(MODULE);
        }
    }

    static class FromProviderModule
    extends AbstractModule {
        FromProviderModule() {
        }

        protected void configure() {
            this.bind(String.class).annotatedWith(Bar.class).toProvider(() -> null);
        }
    }

    static class FromProvidesMethodModule
    extends AbstractModule {
        FromProvidesMethodModule() {
        }

        @Provides
        @Bar
        String provideString() {
            return null;
        }
    }

    static class Foo {
        @Inject
        Foo(@Bar String string) {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Bar {
    }
}

