/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.example;

import junit.framework.Assert;

public class ClientServiceWithFactories {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClient() {
        Service previous = ServiceFactory.getInstance();
        try {
            MockService mock = new MockService();
            ServiceFactory.setInstance(mock);
            Client client = new Client();
            client.go();
            Assert.assertTrue((boolean)mock.isGone());
        }
        finally {
            ServiceFactory.setInstance(previous);
        }
    }

    public static void main(String[] args) {
        new ClientServiceWithFactories().testClient();
    }

    public static class MockService
    implements Service {
        private boolean gone = false;

        @Override
        public void go() {
            this.gone = true;
        }

        public boolean isGone() {
            return this.gone;
        }
    }

    public static class Client {
        public void go() {
            Service service = ServiceFactory.getInstance();
            service.go();
        }
    }

    public static class ServiceFactory {
        private static Service instance = new ServiceImpl();

        private ServiceFactory() {
        }

        public static Service getInstance() {
            return instance;
        }

        public static void setInstance(Service service) {
            instance = service;
        }
    }

    public static class ServiceImpl
    implements Service {
        @Override
        public void go() {
        }
    }

    public static interface Service {
        public void go();
    }
}

