/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.inject.ProvisionException;
import com.google.inject.internal.ErrorId;
import com.google.inject.internal.GuiceInternal;
import com.google.inject.internal.Messages;
import com.google.inject.spi.ErrorDetail;
import com.google.inject.spi.Message;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class MessagesTest {
    @Test
    public void customErrorMessage() {
        ArrayList<Message> messages = new ArrayList<Message>();
        Throwable cause = null;
        messages.add(new Message("example", cause));
        messages.add(MessagesTest.exampleError("a"));
        messages.add(MessagesTest.exampleError("b"));
        messages.add(MessagesTest.exampleError("a"));
        String result = Messages.formatMessages((String)"Example", messages);
        Truth.assertThat((String)result).isEqualTo((Object)"Example:\n\n1) example\n\n2) a\nDuplicate count: 2\n\n3) b\nDuplicate count: 1\n\n3 errors");
    }

    @Test
    public void provisionExceptionWithCustomErrorMessageIsSerializable() {
        Throwable cause = null;
        ProvisionException exception = new ProvisionException((Iterable)ImmutableList.of((Object)MessagesTest.exampleError("Custom error"), (Object)new Message("Generic error", cause)));
        Truth.assertThat((Throwable)((Throwable)SerializableTester.reserialize((Object)((Object)exception)))).hasMessageThat().isEqualTo((Object)"Unable to provision, see the following errors:\n\n1) Custom error\n\n2) Generic error\n\n2 errors");
    }

    private static Message exampleError(String message) {
        return new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.OTHER, (ErrorDetail)new ExampleErrorDetail(message));
    }

    static class ExampleErrorDetail
    extends ErrorDetail<ExampleErrorDetail> {
        ExampleErrorDetail(String message) {
            super(message, (List)ImmutableList.of(), null);
        }

        public void formatDetail(List<ErrorDetail<?>> mergeableErrors, Formatter formatter) {
            formatter.format("Duplicate count: %s%n", mergeableErrors.size() + 1);
        }

        public boolean isMergeable(ErrorDetail<?> otherError) {
            return otherError instanceof ExampleErrorDetail && otherError.getMessage().equals(this.getMessage());
        }

        public ExampleErrorDetail withSources(List<Object> unused) {
            return new ExampleErrorDetail(this.getMessage());
        }
    }
}

