/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Collector;
import com.google.inject.internal.RealMultibinder;
import com.google.inject.internal.SpiUtils;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.util.Modules;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class MultibinderTest
extends TestCase {
    final TypeLiteral<Optional<String>> optionalOfString = new TypeLiteral<Optional<String>>(){};
    final TypeLiteral<Map<String, String>> mapOfStringString = new TypeLiteral<Map<String, String>>(){};
    final TypeLiteral<Set<String>> setOfString = new TypeLiteral<Set<String>>(){};
    final TypeLiteral<Set<Integer>> setOfInteger = new TypeLiteral<Set<Integer>>(){};
    final TypeLiteral<String> stringType = TypeLiteral.get(String.class);
    final TypeLiteral<Integer> intType = TypeLiteral.get(Integer.class);
    final TypeLiteral<List<String>> listOfStrings = new TypeLiteral<List<String>>(){};
    final TypeLiteral<Set<List<String>>> setOfListOfStrings = new TypeLiteral<Set<List<String>>>(){};
    final TypeLiteral<Collection<Provider<String>>> collectionOfProvidersOfStrings = new TypeLiteral<Collection<Provider<String>>>(){};

    public void testMultibinderAggregatesMultipleModules() {
        AbstractModule abc = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
                multibinder.addBinding().toInstance((Object)"C");
            }
        };
        AbstractModule de = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"D");
                multibinder.addBinding().toInstance((Object)"E");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{abc, de});
        Key setKey = Key.get(this.setOfString);
        Set abcde = (Set)injector.getInstance(setKey);
        Set<String> results = this.setOf("A", "B", "C", "D", "E");
        MultibinderTest.assertEquals(results, (Object)abcde);
        SpiUtils.assertSetVisitor(setKey, this.stringType, this.setOf(abc, de), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"), SpiUtils.instance("D"), SpiUtils.instance("E"));
    }

    public void testMultibinderAggregationForAnnotationInstance() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)Names.named((String)"abc"));
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
                multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)Names.named((String)"abc"));
                multibinder.addBinding().toInstance((Object)"C");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key setKey = Key.get(this.setOfString, (Annotation)Names.named((String)"abc"));
        Set abc = (Set)injector.getInstance(setKey);
        Set<String> results = this.setOf("A", "B", "C");
        MultibinderTest.assertEquals(results, (Object)abc);
        SpiUtils.assertSetVisitor(setKey, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"));
    }

    public void testMultibinderAggregationForAnnotationType() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, Abc.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
                multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, Abc.class);
                multibinder.addBinding().toInstance((Object)"C");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key setKey = Key.get(this.setOfString, Abc.class);
        Set abcde = (Set)injector.getInstance(setKey);
        Set<String> results = this.setOf("A", "B", "C");
        MultibinderTest.assertEquals(results, (Object)abcde);
        SpiUtils.assertSetVisitor(setKey, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"));
    }

    public void testMultibinderWithMultipleAnnotationValueSets() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder abcMultibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)Names.named((String)"abc"));
                abcMultibinder.addBinding().toInstance((Object)"A");
                abcMultibinder.addBinding().toInstance((Object)"B");
                abcMultibinder.addBinding().toInstance((Object)"C");
                Multibinder deMultibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)Names.named((String)"de"));
                deMultibinder.addBinding().toInstance((Object)"D");
                deMultibinder.addBinding().toInstance((Object)"E");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key abcSetKey = Key.get(this.setOfString, (Annotation)Names.named((String)"abc"));
        Set abc = (Set)injector.getInstance(abcSetKey);
        Key deSetKey = Key.get(this.setOfString, (Annotation)Names.named((String)"de"));
        Set de = (Set)injector.getInstance(deSetKey);
        Set<String> abcResults = this.setOf("A", "B", "C");
        MultibinderTest.assertEquals(abcResults, (Object)abc);
        Set<String> deResults = this.setOf("D", "E");
        MultibinderTest.assertEquals(deResults, (Object)de);
        SpiUtils.assertSetVisitor(abcSetKey, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"));
        SpiUtils.assertSetVisitor(deSetKey, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("D"), SpiUtils.instance("E"));
    }

    public void testMultibinderWithMultipleAnnotationTypeSets() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder abcMultibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, Abc.class);
                abcMultibinder.addBinding().toInstance((Object)"A");
                abcMultibinder.addBinding().toInstance((Object)"B");
                abcMultibinder.addBinding().toInstance((Object)"C");
                Multibinder deMultibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, De.class);
                deMultibinder.addBinding().toInstance((Object)"D");
                deMultibinder.addBinding().toInstance((Object)"E");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key abcSetKey = Key.get(this.setOfString, Abc.class);
        Set abc = (Set)injector.getInstance(abcSetKey);
        Key deSetKey = Key.get(this.setOfString, De.class);
        Set de = (Set)injector.getInstance(deSetKey);
        Set<String> abcResults = this.setOf("A", "B", "C");
        MultibinderTest.assertEquals(abcResults, (Object)abc);
        Set<String> deResults = this.setOf("D", "E");
        MultibinderTest.assertEquals(deResults, (Object)de);
        SpiUtils.assertSetVisitor(abcSetKey, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"));
        SpiUtils.assertSetVisitor(deSetKey, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("D"), SpiUtils.instance("E"));
    }

    public void testMultibinderWithMultipleSetTypes() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"A");
                Multibinder.newSetBinder((Binder)this.binder(), Integer.class).addBinding().toInstance((Object)1);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        MultibinderTest.assertEquals(this.setOf("A"), (Object)injector.getInstance(Key.get(this.setOfString)));
        MultibinderTest.assertEquals(this.setOf(1), (Object)injector.getInstance(Key.get(this.setOfInteger)));
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("A"));
        SpiUtils.assertSetVisitor(Key.get(this.setOfInteger), this.intType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance(1));
    }

    public void testMultibinderWithEmptySet() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Set set = (Set)injector.getInstance(Key.get(this.setOfString));
        MultibinderTest.assertEquals(Collections.emptySet(), (Object)set);
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, new SpiUtils.BindResult[0]);
    }

    public void testMultibinderSetIsUnmodifiable() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"A");
            }
        }});
        Set set = (Set)injector.getInstance(Key.get(this.setOfString));
        try {
            set.clear();
            MultibinderTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultibinderSetIsSerializable() throws IOException, ClassNotFoundException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"A");
            }
        }});
        Set set = (Set)injector.getInstance(Key.get(this.setOfString));
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);){
            objectOutputStream.writeObject(set);
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteStream.toByteArray()));){
            Object setCopy = objectInputStream.readObject();
            MultibinderTest.assertEquals((Object)set, (Object)setCopy);
        }
    }

    public void testMultibinderSetIsLazy() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), Integer.class).addBinding().toProvider((Provider)new Provider<Integer>(){
                    int nextValue = 1;

                    public Integer get() {
                        return this.nextValue++;
                    }
                });
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        MultibinderTest.assertEquals(this.setOf(1), (Object)injector.getInstance(Key.get(this.setOfInteger)));
        MultibinderTest.assertEquals(this.setOf(2), (Object)injector.getInstance(Key.get(this.setOfInteger)));
        MultibinderTest.assertEquals(this.setOf(3), (Object)injector.getInstance(Key.get(this.setOfInteger)));
        SpiUtils.assertSetVisitor(Key.get(this.setOfInteger), this.intType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.providerInstance(1));
    }

    public void testMultibinderSetForbidsDuplicateElements() {
        AbstractModule module1 = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toProvider(Providers.of((Object)"A"));
            }
        };
        AbstractModule module2 = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module1, module2});
        try {
            injector.getInstance(Key.get(this.setOfString));
            MultibinderTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Duplicate elements found in Multibinder Set<String>.", "Element: A", "Bound at:", "1 : MultibinderTest$19.configure", "2 : MultibinderTest$20.configure");
        }
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(module1, module2), SpiUtils.VisitType.MODULE, false, 0, SpiUtils.instance("A"), SpiUtils.instance("A"));
    }

    public void testMultibinderSetShowsBothElementsIfToStringDifferent() {
        AbstractModule module1 = new AbstractModule(){

            protected void configure() {
                class ValueType {
                    int a;
                    int b;

                    ValueType(int a, int b) {
                        this.a = a;
                        this.b = b;
                    }

                    public boolean equals(Object obj) {
                        return obj instanceof ValueType && ((ValueType)obj).a == this.a;
                    }

                    public int hashCode() {
                        return this.a;
                    }

                    public String toString() {
                        return String.format("ValueType(%d,%d)", this.a, this.b);
                    }
                }
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), ValueType.class);
                multibinder.addBinding().toProvider(Providers.of((Object)new ValueType(1, 2)));
            }
        };
        AbstractModule module2 = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), ValueType.class);
                multibinder.addBinding().toInstance((Object)new ValueType(1, 3));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module1, module2});
        TypeLiteral valueType = TypeLiteral.get(ValueType.class);
        TypeLiteral<Set<ValueType>> setOfValueType = new TypeLiteral<Set<ValueType>>(){};
        try {
            injector.getInstance(Key.get((TypeLiteral)setOfValueType));
            MultibinderTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Duplicate elements found in Multibinder Set<MultibinderTest$1ValueType>.", "Element: ValueType(1,2)", "Bound at: MultibinderTest$21.configure", "Element: ValueType(1,3)", "Bound at: MultibinderTest$22.configure");
        }
        SpiUtils.assertSetVisitor(Key.get((TypeLiteral)setOfValueType), valueType, this.setOf(module1, module2), SpiUtils.VisitType.MODULE, false, 0, SpiUtils.instance(new ValueType(1, 2)), SpiUtils.instance(new ValueType(1, 3)));
    }

    public void testMultibinderSetPermitDuplicateElements() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
            }
        };
        AbstractModule bc = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.permitDuplicates();
                multibinder.addBinding().toInstance((Object)"B");
                multibinder.addBinding().toInstance((Object)"C");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, bc});
        MultibinderTest.assertEquals(this.setOf("A", "B", "C"), (Object)injector.getInstance(Key.get(this.setOfString)));
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(ab, bc), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"));
    }

    public void testMultibinderSetPermitDuplicateElementsFromOtherModule() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
                multibinder.addBinding().toProvider(Providers.of((Object)"B"));
            }
        };
        AbstractModule cd = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.permitDuplicates();
                multibinder.addBinding().toInstance((Object)"C");
                multibinder.addBinding().toInstance((Object)"D");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, cd});
        MultibinderTest.assertEquals(this.setOf("A", "B", "C", "D"), (Object)injector.getInstance(Key.get(this.setOfString)));
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(ab, cd), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.providerInstance("B"), SpiUtils.instance("C"), SpiUtils.instance("D"));
    }

    public void testMultibinderSetPermitDuplicateCallsToPermitDuplicates() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.permitDuplicates();
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
            }
        };
        AbstractModule bc = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.permitDuplicates();
                multibinder.addBinding().toInstance((Object)"B");
                multibinder.addBinding().toInstance((Object)"C");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, bc});
        MultibinderTest.assertEquals(this.setOf("A", "B", "C"), (Object)injector.getInstance(Key.get(this.setOfString)));
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(ab, bc), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"));
    }

    public void testMultibinderSetForbidsNullElements() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toProvider(Providers.of(null));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{m});
        try {
            injector.getInstance(Key.get(this.setOfString));
            MultibinderTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Set injection failed due to null element bound at: MultibinderTest$30.configure");
        }
    }

    public void testSourceLinesInMultibindings() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    Multibinder.newSetBinder((Binder)this.binder(), Integer.class).addBinding();
                }
            }});
            MultibinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), true, "No implementation for Integer", "1  : MultibinderTest$31.configure");
        }
    }

    public void testMultibinderDependencies() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().to(Key.get(String.class, (Annotation)Names.named((String)"b")));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")).to("B");
            }
        }});
        Binding binding = injector.getBinding((Key)new Key<Set<String>>(){});
        HasDependencies withDependencies = (HasDependencies)binding;
        HashSet elements = Sets.newHashSet();
        for (Dependency dependency : withDependencies.getDependencies()) {
            elements.add((String)injector.getInstance(dependency.getKey()));
        }
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)elements);
    }

    public void testMultibinderDependenciesInToolStage() {
        Injector injector = Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().to(Key.get(String.class, (Annotation)Names.named((String)"b")));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")).to("B");
            }
        }});
        Binding binding = injector.getBinding((Key)new Key<Set<String>>(){});
        HasDependencies withDependencies = (HasDependencies)binding;
        InstanceBinding instanceBinding = null;
        LinkedKeyBinding linkedBinding = null;
        for (Dependency dependency : withDependencies.getDependencies()) {
            Binding b = injector.getBinding(dependency.getKey());
            if (b instanceof InstanceBinding) {
                if (instanceBinding != null) {
                    MultibinderTest.fail((String)("Already have an instance binding of: " + instanceBinding + ", and now want to add: " + b));
                    continue;
                }
                instanceBinding = (InstanceBinding)b;
                continue;
            }
            if (b instanceof LinkedKeyBinding) {
                if (linkedBinding != null) {
                    MultibinderTest.fail((String)("Already have a linked binding of: " + linkedBinding + ", and now want to add: " + b));
                    continue;
                }
                linkedBinding = (LinkedKeyBinding)b;
                continue;
            }
            MultibinderTest.fail((String)("Unexpected dependency of: " + dependency));
        }
        MultibinderTest.assertNotNull(instanceBinding);
        MultibinderTest.assertNotNull(linkedBinding);
        MultibinderTest.assertEquals((Object)"A", (Object)instanceBinding.getInstance());
        MultibinderTest.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"b")), (Object)linkedBinding.getLinkedKey());
    }

    public void testBindOrderEqualsIterationOrder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"leonardo");
                multibinder.addBinding().toInstance((Object)"donatello");
                this.install((Module)new AbstractModule(){

                    protected void configure() {
                        Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"michaelangelo");
                    }
                });
            }
        }, new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"raphael");
            }
        }});
        ImmutableList inOrder = ImmutableList.copyOf((Collection)((Collection)injector.getInstance(Key.get(this.setOfString))));
        MultibinderTest.assertEquals((Object)ImmutableList.of((Object)"leonardo", (Object)"donatello", (Object)"michaelangelo", (Object)"raphael"), (Object)inOrder);
    }

    private <T> Set<T> setOf(T ... elements) {
        HashSet result = Sets.newHashSet();
        Collections.addAll(result, elements);
        return result;
    }

    public void testModuleOverrideAndMultibindings() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
            }
        };
        AbstractModule cd = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"C");
                multibinder.addBinding().toInstance((Object)"D");
            }
        };
        AbstractModule ef = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"E");
                multibinder.addBinding().toInstance((Object)"F");
            }
        };
        Module abcd = Modules.override((Module[])new Module[]{ab}).with(new Module[]{cd});
        Injector injector = Guice.createInjector((Module[])new Module[]{abcd, ef});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object[])new String[0]), (Object)injector.getInstance(Key.get(this.setOfString)));
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(abcd, ef), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"), SpiUtils.instance("D"), SpiUtils.instance("E"), SpiUtils.instance("F"));
    }

    public void testModuleOverrideAndMultibindingsWithPermitDuplicates() {
        AbstractModule abc = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
                multibinder.addBinding().toInstance((Object)"C");
                multibinder.permitDuplicates();
            }
        };
        AbstractModule cd = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"C");
                multibinder.addBinding().toInstance((Object)"D");
                multibinder.permitDuplicates();
            }
        };
        AbstractModule ef = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"E");
                multibinder.addBinding().toInstance((Object)"F");
                multibinder.permitDuplicates();
            }
        };
        Module abcd = Modules.override((Module[])new Module[]{abc}).with(new Module[]{cd});
        Injector injector = Guice.createInjector((Module[])new Module[]{abcd, ef});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object[])new String[0]), (Object)injector.getInstance(Key.get(this.setOfString)));
        SpiUtils.assertSetVisitor(Key.get(this.setOfString), this.stringType, this.setOf(abcd, ef), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), SpiUtils.instance("C"), SpiUtils.instance("D"), SpiUtils.instance("E"), SpiUtils.instance("F"));
    }

    public void testModuleOverrideRepeatedInstallsAndMultibindings_toInstance() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"A");
                multibinder.addBinding().toInstance((Object)"B");
            }
        };
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)Guice.createInjector((Module[])new Module[]{ab, ab}).getInstance(Key.get(this.setOfString)));
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, Modules.override((Module[])new Module[]{ab}).with(new Module[]{ab})});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)injector.getInstance(Key.get(this.setOfString)));
    }

    public void testModuleOverrideRepeatedInstallsAndMultibindings_toKey() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Key aKey = Key.get(String.class, (Annotation)Names.named((String)"A_string"));
                Key bKey = Key.get(String.class, (Annotation)Names.named((String)"B_string"));
                this.bind(aKey).toInstance((Object)"A");
                this.bind(bKey).toInstance((Object)"B");
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().to(aKey);
                multibinder.addBinding().to(bKey);
            }
        };
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)Guice.createInjector((Module[])new Module[]{ab, ab}).getInstance(Key.get(this.setOfString)));
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, Modules.override((Module[])new Module[]{ab}).with(new Module[]{ab})});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)injector.getInstance(Key.get(this.setOfString)));
    }

    public void testModuleOverrideRepeatedInstallsAndMultibindings_toProviderInstance() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toProvider(Providers.of((Object)"A"));
                multibinder.addBinding().toProvider(Providers.of((Object)"B"));
            }
        };
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)Guice.createInjector((Module[])new Module[]{ab, ab}).getInstance(Key.get(this.setOfString)));
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, Modules.override((Module[])new Module[]{ab}).with(new Module[]{ab})});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)injector.getInstance(Key.get(this.setOfString)));
    }

    public void testModuleOverrideRepeatedInstallsAndMultibindings_toProviderKey() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toProvider(Key.get(AStringProvider.class));
                multibinder.addBinding().toProvider(Key.get(BStringProvider.class));
            }
        };
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)Guice.createInjector((Module[])new Module[]{ab, ab}).getInstance(Key.get(this.setOfString)));
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, Modules.override((Module[])new Module[]{ab}).with(new Module[]{ab})});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)injector.getInstance(Key.get(this.setOfString)));
    }

    public void testModuleOverrideRepeatedInstallsAndMultibindings_toConstructor() {
        TypeLiteral<Set<StringGrabber>> setOfStringGrabber = new TypeLiteral<Set<StringGrabber>>(){};
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Key aKey = Key.get(String.class, (Annotation)Names.named((String)"A_string"));
                Key bKey = Key.get(String.class, (Annotation)Names.named((String)"B_string"));
                this.bind(aKey).toInstance((Object)"A");
                this.bind(bKey).toInstance((Object)"B");
                this.bind(Integer.class).toInstance((Object)0);
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), StringGrabber.class);
                try {
                    multibinder.addBinding().toConstructor(StringGrabber.class.getConstructor(String.class));
                    multibinder.addBinding().toConstructor(StringGrabber.class.getConstructor(String.class, Integer.TYPE));
                }
                catch (NoSuchMethodException e) {
                    TestCase.fail((String)("No such method: " + e.getMessage()));
                }
            }
        };
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), StringGrabber.values((Iterable)Guice.createInjector((Module[])new Module[]{ab, ab}).getInstance(Key.get((TypeLiteral)setOfStringGrabber))));
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, Modules.override((Module[])new Module[]{ab}).with(new Module[]{ab})});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), StringGrabber.values((Iterable)injector.getInstance(Key.get((TypeLiteral)setOfStringGrabber))));
    }

    public void testDuplicateUnscopedBindings() {
        AbstractModule singleBinding = new AbstractModule(){

            protected void configure() {
                this.bind(Integer.class).to(Key.get(Integer.class, (Annotation)Names.named((String)"A")));
                this.bind(Integer.class).to(Key.get(Integer.class, (Annotation)Names.named((String)"A"))).in(Scopes.NO_SCOPE);
            }

            @Provides
            @Named(value="A")
            int provideInteger() {
                return 5;
            }
        };
        AbstractModule multibinding = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), Integer.class);
                multibinder.addBinding().to(Key.get(Integer.class, (Annotation)Names.named((String)"A")));
                multibinder.addBinding().to(Key.get(Integer.class, (Annotation)Names.named((String)"A"))).in(Scopes.NO_SCOPE);
            }
        };
        MultibinderTest.assertEquals((int)5, (int)((Integer)Guice.createInjector((Module[])new Module[]{singleBinding}).getInstance(Integer.class)));
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)5), (Object)Guice.createInjector((Module[])new Module[]{singleBinding, multibinding}).getInstance(Key.get(this.setOfInteger)));
    }

    public void testKeyHashCodesFixedAtInjectionTime() {
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), MultibinderTest.this.listOfStrings);
                ArrayList list = Lists.newArrayList();
                multibinder.addBinding().toInstance((Object)list);
                list.add("A");
                list.add("B");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ab});
        for (Map.Entry entry : injector.getAllBindings().entrySet()) {
            Key bindingKey = (Key)entry.getKey();
            Key clonedKey = bindingKey.getAnnotation() != null ? bindingKey.ofType(bindingKey.getTypeLiteral()) : (bindingKey.getAnnotationType() != null ? bindingKey.ofType(bindingKey.getTypeLiteral()) : Key.get((TypeLiteral)bindingKey.getTypeLiteral()));
            MultibinderTest.assertEquals((Object)bindingKey, (Object)clonedKey);
            MultibinderTest.assertEquals((String)("Incorrect hashcode for " + bindingKey + " -> " + entry.getValue()), (int)bindingKey.hashCode(), (int)clonedKey.hashCode());
        }
    }

    public void testBindingKeysFixedOnReturnFromGetElements() {
        final ArrayList list = Lists.newArrayList();
        AbstractModule ab = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), MultibinderTest.this.listOfStrings);
                multibinder.addBinding().toInstance((Object)list);
                list.add("A");
                list.add("B");
            }
        };
        InstanceBinding binding = (InstanceBinding)Elements.getElements((Module[])new Module[]{ab}).stream().filter(InstanceBinding.class::isInstance).map(InstanceBinding.class::cast).collect(MoreCollectors.onlyElement());
        Key keyBefore = binding.getKey();
        MultibinderTest.assertEquals(this.listOfStrings, (Object)keyBefore.getTypeLiteral());
        list.add("C");
        Key keyAfter = binding.getKey();
        MultibinderTest.assertSame((Object)keyBefore, (Object)keyAfter);
    }

    public void testConcurrentMutation_bindingsDiffentAtInjectorCreation() {
        final ArrayList list1 = Lists.newArrayList();
        final ArrayList list2 = Lists.newArrayList();
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), MultibinderTest.this.listOfStrings);
                multibinder.addBinding().toInstance((Object)list1);
                multibinder.addBinding().toInstance((Object)list2);
            }
        };
        List elements = Elements.getElements((Module[])new Module[]{module});
        list1.add("A");
        list2.add("B");
        Injector injector = Guice.createInjector((Module[])new Module[]{Elements.getModule((Iterable)elements)});
        list1.add(1, "B");
        list2.add(0, "A");
        try {
            injector.getInstance(Key.get(this.setOfListOfStrings));
            MultibinderTest.fail();
        }
        catch (ProvisionException e) {
            MultibinderTest.assertEquals((int)1, (int)e.getErrorMessages().size());
            Asserts.assertContains(e.getMessage(), "Duplicate elements found in Multibinder Set<List<String>>.");
        }
        list1.remove("A");
        list2.remove("B");
        Set set = (Set)injector.getInstance(Key.get(this.setOfListOfStrings));
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)ImmutableList.of((Object)"A"), (Object)ImmutableList.of((Object)"B")), (Object)set);
    }

    public void testConcurrentMutation_bindingsSameAtInjectorCreation() {
        final ArrayList list1 = Lists.newArrayList((Object[])new String[]{"A"});
        final ArrayList list2 = Lists.newArrayList((Object[])new String[]{"B"});
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), MultibinderTest.this.listOfStrings);
                multibinder.addBinding().toInstance((Object)list1);
                multibinder.addBinding().toInstance((Object)list2);
            }
        };
        List elements = Elements.getElements((Module[])new Module[]{module});
        list1.add(1, "B");
        list2.add(0, "A");
        Injector injector = Guice.createInjector((Module[])new Module[]{Elements.getModule((Iterable)elements)});
        list1.remove("A");
        list2.remove("B");
        Set set = (Set)injector.getInstance(Key.get(this.setOfListOfStrings));
        MultibinderTest.assertTrue((ImmutableSet.of((Object)ImmutableList.of((Object)"A")).equals((Object)set) || ImmutableSet.of((Object)ImmutableList.of((Object)"B")).equals((Object)set) ? 1 : 0) != 0);
    }

    @Marker
    public void testMultibinderMatching() throws Exception {
        Method m = MultibinderTest.class.getDeclaredMethod("testMultibinderMatching", new Class[0]);
        MultibinderTest.assertNotNull((Object)m);
        final Marker marker = m.getAnnotation(Marker.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            public void configure() {
                Multibinder mb1 = Multibinder.newSetBinder((Binder)this.binder(), Integer.class, Marker.class);
                Multibinder mb2 = Multibinder.newSetBinder((Binder)this.binder(), Integer.class, (Annotation)marker);
                mb1.addBinding().toInstance((Object)1);
                mb2.addBinding().toInstance((Object)2);
                TestCase.assertEquals((Object)mb1, (Object)mb2);
            }
        }});
        TypeLiteral<Set<Integer>> t = new TypeLiteral<Set<Integer>>(){};
        Set s1 = (Set)injector.getInstance(Key.get((TypeLiteral)t, Marker.class));
        Set s2 = (Set)injector.getInstance(Key.get((TypeLiteral)t, (Annotation)marker));
        MultibinderTest.assertEquals((Object)s1, (Object)s2);
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(1);
        expected.add(2);
        MultibinderTest.assertEquals(expected, (Object)s1);
    }

    public void testSetAndMapValueAreDistinct() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"A");
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"B").toInstance((Object)"b");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"C");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)"D");
            }
        }});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"A"), (Object)injector.getInstance(Key.get(this.setOfString)));
        MultibinderTest.assertEquals((Object)ImmutableMap.of((Object)"B", (Object)"b"), (Object)injector.getInstance(Key.get(this.mapOfStringString)));
        MultibinderTest.assertEquals((Object)Optional.of((Object)"D"), (Object)injector.getInstance(Key.get(this.optionalOfString)));
    }

    public void testSetAndMapValueAreDistinctInSpi() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class).addBinding().toInstance((Object)"A");
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"B").toInstance((Object)"b");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"C");
            }
        }});
        Collector collector = new Collector();
        Binding mapbinding = injector.getBinding(Key.get(this.mapOfStringString));
        mapbinding.acceptTargetVisitor((BindingTargetVisitor)collector);
        MultibinderTest.assertNotNull(collector.mapbinding);
        Binding setbinding = injector.getBinding(Key.get(this.setOfString));
        setbinding.acceptTargetVisitor((BindingTargetVisitor)collector);
        MultibinderTest.assertNotNull(collector.setbinding);
        Binding optionalbinding = injector.getBinding(Key.get(this.optionalOfString));
        optionalbinding.acceptTargetVisitor((BindingTargetVisitor)collector);
        MultibinderTest.assertNotNull(collector.optionalbinding);
        List bindings = (List)injector.findBindingsByType(this.stringType).stream().filter(Predicates.instanceOf(InstanceBinding.class)).collect(ImmutableList.toImmutableList());
        MultibinderTest.assertEquals((String)bindings.toString(), (int)3, (int)bindings.size());
        Binding a = (Binding)bindings.get(0);
        Binding b = (Binding)bindings.get(1);
        Binding c = (Binding)bindings.get(2);
        MultibinderTest.assertEquals((String)"A", (String)((String)((InstanceBinding)a).getInstance()));
        MultibinderTest.assertEquals((String)"b", (String)((String)((InstanceBinding)b).getInstance()));
        MultibinderTest.assertEquals((String)"C", (String)((String)((InstanceBinding)c).getInstance()));
        MultibinderTest.assertFalse((boolean)collector.mapbinding.containsElement((Element)a));
        MultibinderTest.assertTrue((boolean)collector.mapbinding.containsElement((Element)b));
        MultibinderTest.assertFalse((boolean)collector.mapbinding.containsElement((Element)c));
        MultibinderTest.assertTrue((boolean)collector.setbinding.containsElement((Element)a));
        MultibinderTest.assertFalse((boolean)collector.setbinding.containsElement((Element)b));
        MultibinderTest.assertFalse((boolean)collector.setbinding.containsElement((Element)c));
        MultibinderTest.assertFalse((boolean)collector.optionalbinding.containsElement((Element)a));
        MultibinderTest.assertFalse((boolean)collector.optionalbinding.containsElement((Element)b));
        MultibinderTest.assertTrue((boolean)collector.optionalbinding.containsElement((Element)c));
    }

    public void testMultibinderCanInjectCollectionOfProviders() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toProvider(Providers.of((Object)"A"));
                multibinder.addBinding().toProvider(Providers.of((Object)"B"));
                multibinder.addBinding().toInstance((Object)"C");
            }
        };
        ImmutableList expectedValues = ImmutableList.of((Object)"A", (Object)"B", (Object)"C");
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Collection providers = (Collection)injector.getInstance(Key.get(this.collectionOfProvidersOfStrings));
        MultibinderTest.assertEquals((Object)expectedValues, this.collectValues(providers));
        Collection javaxProviders = (Collection)injector.getInstance(Key.get((TypeLiteral)RealMultibinder.collectionOfJavaxProvidersOf(this.stringType)));
        MultibinderTest.assertEquals((Object)expectedValues, this.collectValues(javaxProviders));
    }

    public void testMultibinderCanInjectCollectionOfProvidersWithAnnotation() {
        Named ann = Names.named((String)"foo");
        AbstractModule module = new AbstractModule((Annotation)ann){
            final /* synthetic */ Annotation val$ann;
            {
                this.val$ann = annotation;
            }

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)this.val$ann);
                multibinder.addBinding().toProvider(Providers.of((Object)"A"));
                multibinder.addBinding().toProvider(Providers.of((Object)"B"));
                multibinder.addBinding().toInstance((Object)"C");
            }
        };
        ImmutableList expectedValues = ImmutableList.of((Object)"A", (Object)"B", (Object)"C");
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Collection providers = (Collection)injector.getInstance(Key.get(this.collectionOfProvidersOfStrings, (Annotation)ann));
        Collection values = this.collectValues(providers);
        MultibinderTest.assertEquals((Object)expectedValues, values);
        Collection javaxProviders = (Collection)injector.getInstance(Key.get((TypeLiteral)RealMultibinder.collectionOfJavaxProvidersOf(this.stringType), (Annotation)ann));
        MultibinderTest.assertEquals((Object)expectedValues, this.collectValues(javaxProviders));
    }

    public void testMultibindingProviderDependencies() {
        Named setAnn = Names.named((String)"foo");
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((Annotation)setAnn){
            final /* synthetic */ Annotation val$setAnn;
            {
                this.val$setAnn = annotation;
            }

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)this.val$setAnn);
                multibinder.addBinding().toInstance((Object)"a");
                multibinder.addBinding().toInstance((Object)"b");
            }
        }});
        HasDependencies providerBinding = (HasDependencies)injector.getBinding((Key)new Key<Collection<Provider<String>>>((Annotation)setAnn){});
        HasDependencies setBinding = (HasDependencies)injector.getBinding((Key)new Key<Set<String>>((Annotation)setAnn){});
        MultibinderTest.assertEquals((String)setBinding.getDependencies().toString(), (int)2, (int)setBinding.getDependencies().size());
        HashSet expected = Sets.newHashSet();
        for (Dependency dep : setBinding.getDependencies()) {
            Key key = dep.getKey();
            Dependency providerDependency = Dependency.get((Key)key.ofType((Type)Types.providerOf((Type)key.getTypeLiteral().getType())));
            expected.add(providerDependency);
        }
        MultibinderTest.assertEquals((Object)expected, (Object)providerBinding.getDependencies());
    }

    public void testEmptyMultibinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Multibinder.newSetBinder((Binder)this.binder(), String.class);
            }
        }});
        MultibinderTest.assertEquals((Object)ImmutableSet.of(), (Object)injector.getInstance((Key)new Key<Set<String>>(){}));
        MultibinderTest.assertEquals((Object)ImmutableList.of(), (Object)injector.getInstance((Key)new Key<Collection<Provider<String>>>(){}));
    }

    public void testMultibinderDependsOnInstanceBindingWithInjectionPoints() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){
            private Provider<Set<ObjectWithInjectionPoint>> provider;

            protected void configure() {
                this.bind(Object.class).toInstance((Object)this);
                this.bind(String.class).toInstance((Object)"foo");
                this.provider = this.getProvider((Key)new Key<Set<ObjectWithInjectionPoint>>(){});
                Multibinder.newSetBinder((Binder)this.binder(), ObjectWithInjectionPoint.class).addBinding().toInstance((Object)new ObjectWithInjectionPoint());
            }

            @Inject
            void setter(String s) {
                for (ObjectWithInjectionPoint item : (Set)this.provider.get()) {
                    TestCase.assertTrue((boolean)item.setterHasBeenCalled);
                }
            }
        }});
    }

    public void testMultibinderWithWildcard() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"a");
                multibinder.addBinding().toInstance((Object)"b");
                multibinder.addBinding().toInstance((Object)"c");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Set set = (Set)injector.getInstance((Key)new Key<Set<String>>(){});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)set);
        Set setOfWildcard = (Set)injector.getInstance((Key)new Key<Set<? extends String>>(){});
        MultibinderTest.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)setOfWildcard);
    }

    public void testMultibinderConflictsWithExistingWildcard() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"a");
                multibinder.addBinding().toInstance((Object)"b");
                multibinder.addBinding().toInstance((Object)"c");
            }

            @Provides
            public Set<? extends String> provideStrings() {
                return ImmutableSet.of((Object)"d", (Object)"e", (Object)"f");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            MultibinderTest.fail();
        }
        catch (CreationException e) {
            MultibinderTest.assertTrue((boolean)e.getMessage().contains("Set<? extends String> was bound multiple times."));
        }
    }

    public void testMultibinderConflictsWithExistingMultibinder() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
                multibinder.addBinding().toInstance((Object)"a");
                multibinder.addBinding().toInstance((Object)"b");
                multibinder.addBinding().toInstance((Object)"c");
                Multibinder multibinder2 = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get((Type)Types.subtypeOf(String.class)));
                multibinder2.addBinding().toInstance((Object)"d");
                multibinder2.addBinding().toInstance((Object)"e");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            MultibinderTest.fail();
        }
        catch (CreationException e) {
            MultibinderTest.assertTrue((boolean)e.getMessage().contains("Set<? extends String> was bound multiple times"));
        }
    }

    private <T> Collection<T> collectValues(Collection<? extends javax.inject.Provider<T>> providers) {
        ArrayList values = Lists.newArrayList();
        for (javax.inject.Provider<T> provider : providers) {
            values.add(provider.get());
        }
        return values;
    }

    private static final class ObjectWithInjectionPoint {
        boolean setterHasBeenCalled;

        private ObjectWithInjectionPoint() {
        }

        @Inject
        void setter(String dummy) {
            this.setterHasBeenCalled = true;
        }
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Marker {
    }

    private static class StringGrabber {
        private final String string;

        public StringGrabber(@Named(value="A_string") String string) {
            this.string = string;
        }

        public StringGrabber(@Named(value="B_string") String string, int unused) {
            this.string = string;
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof StringGrabber && ((StringGrabber)obj).string.equals(this.string);
        }

        public String toString() {
            return "StringGrabber(" + this.string + ")";
        }

        static Set<String> values(Iterable<StringGrabber> grabbers) {
            HashSet<String> result = new HashSet<String>();
            for (StringGrabber grabber : grabbers) {
                result.add(grabber.string);
            }
            return result;
        }
    }

    private static class BStringProvider
    implements Provider<String> {
        private BStringProvider() {
        }

        public String get() {
            return "B";
        }
    }

    private static class AStringProvider
    implements Provider<String> {
        private AStringProvider() {
        }

        public String get() {
            return "A";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface De {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Abc {
    }
}

