/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.RealOptionalBinder;
import com.google.inject.internal.SpiUtils;
import com.google.inject.internal.WeakKeySetUtils;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Elements;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.util.Modules;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;

public class OptionalBinderTest
extends TestCase {
    final Key<String> stringKey = Key.get(String.class);
    final TypeLiteral<com.google.common.base.Optional<String>> optionalOfString = new TypeLiteral<com.google.common.base.Optional<String>>(){};
    final TypeLiteral<Optional<String>> javaOptionalOfString = new TypeLiteral<Optional<String>>(){};
    final TypeLiteral<com.google.common.base.Optional<Provider<String>>> optionalOfProviderString = new TypeLiteral<com.google.common.base.Optional<Provider<String>>>(){};
    final TypeLiteral<Optional<Provider<String>>> javaOptionalOfProviderString = new TypeLiteral<Optional<Provider<String>>>(){};
    final TypeLiteral<com.google.common.base.Optional<javax.inject.Provider<String>>> optionalOfJavaxProviderString = new TypeLiteral<com.google.common.base.Optional<javax.inject.Provider<String>>>(){};
    final TypeLiteral<Optional<javax.inject.Provider<String>>> javaOptionalOfJavaxProviderString = new TypeLiteral<Optional<javax.inject.Provider<String>>>(){};
    final Key<Integer> intKey = Key.get(Integer.class);
    final TypeLiteral<com.google.common.base.Optional<Integer>> optionalOfInteger = new TypeLiteral<com.google.common.base.Optional<Integer>>(){};
    final TypeLiteral<Optional<Integer>> javaOptionalOfInteger = new TypeLiteral<Optional<Integer>>(){};
    final TypeLiteral<com.google.common.base.Optional<Provider<Integer>>> optionalOfProviderInteger = new TypeLiteral<com.google.common.base.Optional<Provider<Integer>>>(){};
    final TypeLiteral<Optional<Provider<Integer>>> javaOptionalOfProviderInteger = new TypeLiteral<Optional<Provider<Integer>>>(){};
    final TypeLiteral<com.google.common.base.Optional<javax.inject.Provider<Integer>>> optionalOfJavaxProviderInteger = new TypeLiteral<com.google.common.base.Optional<javax.inject.Provider<Integer>>>(){};
    final TypeLiteral<Optional<javax.inject.Provider<Integer>>> javaOptionalOfJavaxProviderInteger = new TypeLiteral<Optional<javax.inject.Provider<Integer>>>(){};
    final TypeLiteral<List<String>> listOfStrings = new TypeLiteral<List<String>>(){};

    public void testTypeNotBoundByDefault() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                this.requireBinding((Key)new Key<com.google.common.base.Optional<String>>(){});
                this.requireBinding(String.class);
                this.binder().requireExplicitBindings();
                this.requireBinding(Key.get(OptionalBinderTest.this.javaOptionalOfString));
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            OptionalBinderTest.fail();
        }
        catch (CreationException ce) {
            Asserts.assertContains(ce.getMessage(), "Explicit bindings are required and String is not explicitly bound.");
            OptionalBinderTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
        }
    }

    public void testLinkedTypeSameAsBaseType() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), MyClass.class).setBinding().to(MyClass.class);
            }
        };
        CreationException ce = (CreationException)Assert.assertThrows(CreationException.class, () -> OptionalBinderTest.lambda$testLinkedTypeSameAsBaseType$0((Module)module));
        Asserts.assertContains(ce.getMessage(), "Binding points to itself. Key: OptionalBinderTest$MyClass");
    }

    public void testLinkedAndBaseTypeHaveDifferentAnnotations() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(MyClass.class, (Annotation)Names.named((String)"foo"))).setBinding().to(Key.get(MyClass.class, (Annotation)Names.named((String)"moo")));
            }

            @Provides
            @Named(value="moo")
            MyClass provideString() {
                return new MyClass();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertNotNull((Object)injector);
    }

    public void testOptionalIsAbsentByDefault() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertFalse((boolean)optionalP.isPresent());
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertFalse((boolean)optionalJxP.isPresent());
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, null, null, null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertFalse((boolean)optionalP.isPresent());
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertFalse((boolean)optionalJxP.isPresent());
    }

    public void testUsesUserBoundValue() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
            }

            @Provides
            String provideString() {
                return "foo";
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals((String)"foo", (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertEquals((String)"foo", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertEquals((String)"foo", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertEquals((String)"foo", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, null, null, SpiUtils.providerInstance("foo"));
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertEquals((String)"foo", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertEquals((String)"foo", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertEquals((String)"foo", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testUsesUserBoundValueNullProvidersMakeAbsent() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
            }

            @Provides
            String provideString() {
                return null;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals(null, (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertEquals(null, (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertEquals(null, (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, null, null, SpiUtils.providerInstance(null));
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertEquals(null, (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertEquals(null, (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testOptionalBinderDependsOnJitBinding() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), JitBinding.class);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertFalse((boolean)((com.google.common.base.Optional)injector.getInstance(this.optionalKey(JitBinding.class))).isPresent());
        OptionalBinderTest.assertNull((Object)injector.getExistingBinding(Key.get(JitBinding.class)));
        module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), JitBinding.class);
                this.bind(DependsOnJitBinding.class);
            }
        };
        injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertTrue((boolean)((com.google.common.base.Optional)injector.getInstance(this.optionalKey(JitBinding.class))).isPresent());
        OptionalBinderTest.assertNotNull((Object)injector.getExistingBinding(Key.get(JitBinding.class)));
        module = new AbstractModule(){

            protected void configure() {
                this.bind(Object.class).toProvider((Provider)new Provider<Object>(){

                    @Inject
                    void setter(Injector injector) {
                        injector.getInstance(JitBinding.class);
                    }

                    public Object get() {
                        return null;
                    }
                });
                OptionalBinder.newOptionalBinder((Binder)this.binder(), JitBinding.class);
            }
        };
        injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertFalse((boolean)((com.google.common.base.Optional)injector.getInstance(this.optionalKey(JitBinding.class))).isPresent());
        OptionalBinderTest.assertNotNull((Object)injector.getExistingBinding(Key.get(JitBinding.class)));
    }

    public <T> Key<com.google.common.base.Optional<T>> optionalKey(Class<T> type) {
        return Key.get((TypeLiteral)RealOptionalBinder.optionalOf((TypeLiteral)TypeLiteral.get(type)));
    }

    public void testSetDefault() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"a");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals((String)"a", (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, SpiUtils.instance("a"), null, null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testSetBinding() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)"a");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals((String)"a", (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, null, SpiUtils.instance("a"), null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testSetBindingOverridesDefault() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder optionalBinder = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                optionalBinder.setDefault().toInstance((Object)"a");
                optionalBinder.setBinding().toInstance((Object)"b");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals((String)"b", (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, SpiUtils.instance("a"), SpiUtils.instance("b"), null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testSpreadAcrossModules() throws Exception {
        AbstractModule module1 = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
            }
        };
        AbstractModule module2 = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"a");
            }
        };
        AbstractModule module3 = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)"b");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module1, module2, module3});
        OptionalBinderTest.assertEquals((String)"b", (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module1, module2, module3), SpiUtils.VisitType.BOTH, 0, SpiUtils.instance("a"), SpiUtils.instance("b"), null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testExactSameBindingCollapses_defaults() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)new String("a"));
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)new String("a"));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals((String)"a", (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, SpiUtils.instance("a"), null, null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testExactSameBindingCollapses_actual() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)new String("a"));
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)new String("a"));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals((String)"a", (String)((String)injector.getInstance(String.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, null, SpiUtils.instance("a"), null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"a", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testDifferentBindingsFail_defaults() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"a");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"b");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            OptionalBinderTest.fail();
        }
        catch (CreationException ce) {
            OptionalBinderTest.assertEquals((String)ce.getMessage(), (int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "String annotated with @RealOptionalBinder$Default was bound multiple times.");
        }
    }

    public void testDifferentBindingsFail_actual() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)"a");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)"b");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            OptionalBinderTest.fail();
        }
        catch (CreationException ce) {
            OptionalBinderTest.assertEquals((String)ce.getMessage(), (int)1, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "String annotated with @RealOptionalBinder$Actual was bound multiple times.", "1  : " + OptionalBinderTest.getShortName((Module)module) + ".configure", "2  : " + OptionalBinderTest.getShortName((Module)module) + ".configure");
        }
    }

    public void testDifferentBindingsFail_both() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"a");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"b");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)"b");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toInstance((Object)"c");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            OptionalBinderTest.fail();
        }
        catch (CreationException ce) {
            OptionalBinderTest.assertEquals((String)ce.getMessage(), (int)2, (int)ce.getErrorMessages().size());
            Asserts.assertContains(ce.getMessage(), "String annotated with @RealOptionalBinder$Default was bound multiple times.", "String annotated with @RealOptionalBinder$Actual was bound multiple times.");
        }
    }

    public void testQualifiedAggregatesTogether() throws Exception {
        AbstractModule module1 = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(String.class, (Annotation)Names.named((String)"foo")));
            }
        };
        AbstractModule module2 = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(String.class, (Annotation)Names.named((String)"foo"))).setDefault().toInstance((Object)"a");
            }
        };
        AbstractModule module3 = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(String.class, (Annotation)Names.named((String)"foo"))).setBinding().toInstance((Object)"b");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module1, module2, module3});
        OptionalBinderTest.assertEquals((String)"b", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"foo")))));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString, (Annotation)Names.named((String)"foo")));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)optional.get()));
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString, (Annotation)Names.named((String)"foo")));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((Provider)optionalP.get()).get()));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString, (Annotation)Names.named((String)"foo")));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
        SpiUtils.assertOptionalVisitor(Key.get(String.class, (Annotation)Names.named((String)"foo")), this.setOf(module1, module2, module3), SpiUtils.VisitType.BOTH, 0, SpiUtils.instance("a"), SpiUtils.instance("b"), null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString, (Annotation)Names.named((String)"foo")))));
        OptionalBinderTest.assertTrue((boolean)optional.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString, (Annotation)Names.named((String)"foo")))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString, (Annotation)Names.named((String)"foo")))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertEquals((String)"b", (String)((String)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testMultipleDifferentOptionals() {
        final Key bKey = Key.get(String.class, (Annotation)Names.named((String)"b"));
        final Key cKey = Key.get(String.class, (Annotation)Names.named((String)"c"));
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"a");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), Integer.class).setDefault().toInstance((Object)1);
                OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)bKey).setDefault().toInstance((Object)"b");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)cKey).setDefault().toInstance((Object)"c");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertEquals((String)"a", (String)((String)injector.getInstance(String.class)));
        OptionalBinderTest.assertEquals((int)1, (int)((Integer)injector.getInstance(Integer.class)));
        OptionalBinderTest.assertEquals((String)"b", (String)((String)injector.getInstance(bKey)));
        OptionalBinderTest.assertEquals((String)"c", (String)((String)injector.getInstance(cKey)));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 3, SpiUtils.instance("a"), null, null);
        SpiUtils.assertOptionalVisitor(this.intKey, this.setOf(module), SpiUtils.VisitType.BOTH, 3, SpiUtils.instance(1), null, null);
        SpiUtils.assertOptionalVisitor(bKey, this.setOf(module), SpiUtils.VisitType.BOTH, 3, SpiUtils.instance("b"), null, null);
        SpiUtils.assertOptionalVisitor(cKey, this.setOf(module), SpiUtils.VisitType.BOTH, 3, SpiUtils.instance("c"), null, null);
    }

    public void testOptionalIsAppropriatelyLazy() throws Exception {
        AbstractModule module = new AbstractModule(){
            int nextValue = 1;

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), Integer.class).setDefault().to(Key.get(Integer.class, (Annotation)Names.named((String)"foo")));
            }

            @Provides
            @Named(value="foo")
            int provideInt() {
                return this.nextValue++;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderInteger));
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderInteger));
        OptionalBinderTest.assertEquals((int)1, (int)((Integer)injector.getInstance(Integer.class)));
        OptionalBinderTest.assertEquals((int)2, (int)((Integer)injector.getInstance(Integer.class)));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfInteger));
        OptionalBinderTest.assertEquals((int)3, (int)((Integer)optional.get()));
        OptionalBinderTest.assertEquals((int)3, (int)((Integer)optional.get()));
        OptionalBinderTest.assertEquals((int)4, (int)((Integer)((com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfInteger))).get()));
        OptionalBinderTest.assertEquals((int)5, (int)((Integer)((Provider)optionalP.get()).get()));
        OptionalBinderTest.assertEquals((int)6, (int)((Integer)((Provider)optionalP.get()).get()));
        OptionalBinderTest.assertEquals((int)7, (int)((Integer)((javax.inject.Provider)optionalJxP.get()).get()));
        OptionalBinderTest.assertEquals((int)8, (int)((Integer)((javax.inject.Provider)optionalJxP.get()).get()));
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfInteger))));
        OptionalBinderTest.assertEquals((int)9, (int)((Integer)optional.get()));
        OptionalBinderTest.assertEquals((int)9, (int)((Integer)optional.get()));
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfInteger))));
        OptionalBinderTest.assertEquals((int)10, (int)((Integer)optional.get()));
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderInteger))));
        OptionalBinderTest.assertEquals((int)11, (int)((Integer)((Provider)optionalP.get()).get()));
        OptionalBinderTest.assertEquals((int)12, (int)((Integer)((Provider)optionalP.get()).get()));
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderInteger))));
        OptionalBinderTest.assertEquals((int)13, (int)((Integer)((javax.inject.Provider)optionalJxP.get()).get()));
        OptionalBinderTest.assertEquals((int)14, (int)((Integer)((javax.inject.Provider)optionalJxP.get()).get()));
    }

    public void testLinkedToNullProvidersMakeAbsentValuesAndPresentProviders_default() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toProvider(Providers.of(null));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertNull((Object)injector.getInstance(String.class));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertNull((Object)((Provider)optionalP.get()).get());
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertNull((Object)((javax.inject.Provider)optionalJxP.get()).get());
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, SpiUtils.providerInstance(null), null, null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertNull((Object)((Provider)optionalP.get()).get());
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertNull((Object)((javax.inject.Provider)optionalJxP.get()).get());
    }

    public void testLinkedToNullProvidersMakeAbsentValuesAndPresentProviders_actual() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toProvider(Providers.of(null));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertNull((Object)injector.getInstance(String.class));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertNull((Object)((Provider)optionalP.get()).get());
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertNull((Object)((javax.inject.Provider)optionalJxP.get()).get());
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, null, SpiUtils.providerInstance(null), null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertNull((Object)((Provider)optionalP.get()).get());
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertNull((Object)((javax.inject.Provider)optionalJxP.get()).get());
    }

    public void testLinkedToNullActualDoesntFallbackToDefault() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setDefault().toInstance((Object)"a");
                OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class).setBinding().toProvider(Providers.of(null));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OptionalBinderTest.assertNull((Object)injector.getInstance(String.class));
        com.google.common.base.Optional optional = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfString));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        com.google.common.base.Optional optionalP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertNull((Object)((Provider)optionalP.get()).get());
        com.google.common.base.Optional optionalJxP = (com.google.common.base.Optional)injector.getInstance(Key.get(this.optionalOfJavaxProviderString));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertNull((Object)((Provider)optionalP.get()).get());
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(module), SpiUtils.VisitType.BOTH, 0, SpiUtils.instance("a"), SpiUtils.providerInstance(null), null);
        optional = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfString))));
        OptionalBinderTest.assertFalse((boolean)optional.isPresent());
        optionalP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalP.isPresent());
        OptionalBinderTest.assertNull((Object)((Provider)optionalP.get()).get());
        optionalJxP = com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)injector.getInstance(Key.get(this.javaOptionalOfJavaxProviderString))));
        OptionalBinderTest.assertTrue((boolean)optionalJxP.isPresent());
        OptionalBinderTest.assertNull((Object)((javax.inject.Provider)optionalJxP.get()).get());
    }

    public void testSourceLinesInException() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), Integer.class).setDefault();
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            OptionalBinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "No implementation for Integer", OptionalBinderTest.getShortName((Module)module) + ".configure");
        }
    }

    public void testDependencies_both() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                OptionalBinder optionalbinder = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                optionalbinder.setDefault().toInstance((Object)"A");
                optionalbinder.setBinding().to(Key.get(String.class, (Annotation)Names.named((String)"b")));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")).to("B");
            }
        }});
        Binding binding = injector.getBinding(Key.get(String.class));
        HasDependencies withDependencies = (HasDependencies)binding;
        HashSet elements = Sets.newHashSet();
        elements.addAll(this.recurseForDependencies(injector, withDependencies));
        OptionalBinderTest.assertEquals((Object)ImmutableSet.of((Object)"B"), (Object)elements);
    }

    public void testDependencies_actual() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                OptionalBinder optionalbinder = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                optionalbinder.setBinding().to(Key.get(String.class, (Annotation)Names.named((String)"b")));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")).to("B");
            }
        }});
        Binding binding = injector.getBinding(Key.get(String.class));
        HasDependencies withDependencies = (HasDependencies)binding;
        HashSet elements = Sets.newHashSet();
        elements.addAll(this.recurseForDependencies(injector, withDependencies));
        OptionalBinderTest.assertEquals((Object)ImmutableSet.of((Object)"B"), (Object)elements);
    }

    public void testDependencies_default() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                OptionalBinder optionalbinder = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                optionalbinder.setDefault().toInstance((Object)"A");
            }
        }});
        Binding binding = injector.getBinding(Key.get(String.class));
        HasDependencies withDependencies = (HasDependencies)binding;
        HashSet elements = Sets.newHashSet();
        elements.addAll(this.recurseForDependencies(injector, withDependencies));
        OptionalBinderTest.assertEquals((Object)ImmutableSet.of((Object)"A"), (Object)elements);
    }

    private Set<String> recurseForDependencies(Injector injector, HasDependencies hasDependencies) {
        HashSet elements = Sets.newHashSet();
        for (Dependency dependency : hasDependencies.getDependencies()) {
            Binding binding = injector.getBinding(dependency.getKey());
            HasDependencies deps = (HasDependencies)binding;
            if (binding instanceof InstanceBinding) {
                elements.add((String)((InstanceBinding)binding).getInstance());
                continue;
            }
            elements.addAll(this.recurseForDependencies(injector, deps));
        }
        return elements;
    }

    public void testModuleOverrideRepeatedInstalls_toInstance() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                b.setDefault().toInstance((Object)"A");
                b.setBinding().toInstance((Object)"B");
            }
        };
        OptionalBinderTest.assertEquals((String)"B", (String)((String)Guice.createInjector((Module[])new Module[]{m, m}).getInstance(Key.get(String.class))));
        Injector injector = Guice.createInjector((Module[])new Module[]{m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})});
        OptionalBinderTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class))));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})), SpiUtils.VisitType.BOTH, 0, SpiUtils.instance("A"), SpiUtils.instance("B"), null);
    }

    public void testModuleOverrideRepeatedInstalls_toKey() {
        final Key aKey = Key.get(String.class, (Annotation)Names.named((String)"A_string"));
        final Key bKey = Key.get(String.class, (Annotation)Names.named((String)"B_string"));
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                this.bind(aKey).toInstance((Object)"A");
                this.bind(bKey).toInstance((Object)"B");
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                b.setDefault().to(aKey);
                b.setBinding().to(bKey);
            }
        };
        OptionalBinderTest.assertEquals((String)"B", (String)((String)Guice.createInjector((Module[])new Module[]{m, m}).getInstance(Key.get(String.class))));
        Injector injector = Guice.createInjector((Module[])new Module[]{m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})});
        OptionalBinderTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class))));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})), SpiUtils.VisitType.BOTH, 0, SpiUtils.linked(aKey), SpiUtils.linked(bKey), null);
    }

    public void testModuleOverrideRepeatedInstalls_toProviderInstance() {
        final Provider aProvider = Providers.of((Object)"A");
        final Provider bProvider = Providers.of((Object)"B");
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                b.setDefault().toProvider(aProvider);
                b.setBinding().toProvider(bProvider);
            }
        };
        OptionalBinderTest.assertEquals((String)"B", (String)((String)Guice.createInjector((Module[])new Module[]{m, m}).getInstance(Key.get(String.class))));
        Injector injector = Guice.createInjector((Module[])new Module[]{m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})});
        OptionalBinderTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class))));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})), SpiUtils.VisitType.BOTH, 0, SpiUtils.providerInstance("A"), SpiUtils.providerInstance("B"), null);
    }

    public void testModuleOverrideRepeatedInstalls_toProviderKey() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), String.class);
                b.setDefault().toProvider(Key.get(AStringProvider.class));
                b.setBinding().toProvider(Key.get(BStringProvider.class));
            }
        };
        OptionalBinderTest.assertEquals((String)"B", (String)((String)Guice.createInjector((Module[])new Module[]{m, m}).getInstance(Key.get(String.class))));
        Injector injector = Guice.createInjector((Module[])new Module[]{m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})});
        OptionalBinderTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class))));
        SpiUtils.assertOptionalVisitor(this.stringKey, this.setOf(m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})), SpiUtils.VisitType.BOTH, 0, SpiUtils.providerKey(Key.get(AStringProvider.class)), SpiUtils.providerKey(Key.get(BStringProvider.class)), null);
    }

    public void testModuleOverrideRepeatedInstalls_toConstructor() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                Key aKey = Key.get(String.class, (Annotation)Names.named((String)"A_string"));
                Key bKey = Key.get(String.class, (Annotation)Names.named((String)"B_string"));
                this.bind(aKey).toInstance((Object)"A");
                this.bind(bKey).toInstance((Object)"B");
                this.bind(Integer.class).toInstance((Object)0);
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), StringGrabber.class);
                try {
                    b.setDefault().toConstructor(StringGrabber.class.getConstructor(String.class));
                    b.setBinding().toConstructor(StringGrabber.class.getConstructor(String.class, Integer.TYPE));
                }
                catch (NoSuchMethodException e) {
                    TestCase.fail((String)("No such method: " + e.getMessage()));
                }
            }
        };
        OptionalBinderTest.assertEquals((String)"B", (String)((StringGrabber)Guice.createInjector((Module[])new Module[]{m, m}).getInstance(Key.get(StringGrabber.class))).string);
        Injector injector = Guice.createInjector((Module[])new Module[]{m, Modules.override((Module[])new Module[]{m}).with(new Module[]{m})});
        OptionalBinderTest.assertEquals((String)"B", (String)((StringGrabber)injector.getInstance(Key.get(StringGrabber.class))).string);
    }

    public void testDuplicateUnscopedBindings() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), Integer.class);
                b.setDefault().to(Key.get(Integer.class, (Annotation)Names.named((String)"foo")));
                b.setDefault().to(Key.get(Integer.class, (Annotation)Names.named((String)"foo"))).in(Scopes.NO_SCOPE);
                b.setBinding().to(Key.get(Integer.class, (Annotation)Names.named((String)"foo")));
                b.setBinding().to(Key.get(Integer.class, (Annotation)Names.named((String)"foo"))).in(Scopes.NO_SCOPE);
            }

            @Provides
            @Named(value="foo")
            int provideInt() {
                return 5;
            }
        };
        OptionalBinderTest.assertEquals((int)5, (int)((Integer)Guice.createInjector((Module[])new Module[]{m}).getInstance(Integer.class)));
    }

    public void testKeyHashCodesFixedAtInjectionTime() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), OptionalBinderTest.this.listOfStrings);
                ArrayList list = Lists.newArrayList();
                b.setDefault().toInstance((Object)list);
                b.setBinding().toInstance((Object)list);
                list.add("A");
                list.add("B");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{m});
        for (Map.Entry entry : injector.getAllBindings().entrySet()) {
            Key bindingKey = (Key)entry.getKey();
            Key clonedKey = bindingKey.getAnnotation() != null ? bindingKey.ofType(bindingKey.getTypeLiteral()) : (bindingKey.getAnnotationType() != null ? bindingKey.ofType(bindingKey.getTypeLiteral()) : Key.get((TypeLiteral)bindingKey.getTypeLiteral()));
            OptionalBinderTest.assertEquals((Object)bindingKey, (Object)clonedKey);
            OptionalBinderTest.assertEquals((String)("Incorrect hashcode for " + bindingKey + " -> " + entry.getValue()), (int)bindingKey.hashCode(), (int)clonedKey.hashCode());
        }
    }

    public void testBindingKeysFixedOnReturnFromGetElements() {
        final ArrayList list = Lists.newArrayList();
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                OptionalBinder b = OptionalBinder.newOptionalBinder((Binder)this.binder(), OptionalBinderTest.this.listOfStrings);
                b.setDefault().toInstance((Object)list);
                list.add("A");
                list.add("B");
            }
        };
        InstanceBinding binding = (InstanceBinding)Elements.getElements((Module[])new Module[]{m}).stream().filter(InstanceBinding.class::isInstance).map(InstanceBinding.class::cast).collect(MoreCollectors.onlyElement());
        Key keyBefore = binding.getKey();
        OptionalBinderTest.assertEquals(this.listOfStrings, (Object)keyBefore.getTypeLiteral());
        list.add("C");
        Key keyAfter = binding.getKey();
        OptionalBinderTest.assertSame((Object)keyBefore, (Object)keyAfter);
    }

    @Marker
    public void testMatchingMarkerAnnotations() throws Exception {
        Method m = OptionalBinderTest.class.getDeclaredMethod("testMatchingMarkerAnnotations", new Class[0]);
        OptionalBinderTest.assertNotNull((Object)m);
        final Marker marker = m.getAnnotation(Marker.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            public void configure() {
                OptionalBinder mb1 = OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(Integer.class, Marker.class));
                OptionalBinder mb2 = OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(Integer.class, (Annotation)marker));
                mb1.setDefault().toInstance((Object)1);
                mb2.setBinding().toInstance((Object)2);
                TestCase.assertEquals((Object)mb1, (Object)mb2);
            }
        }});
        Integer i1 = (Integer)injector.getInstance(Key.get(Integer.class, Marker.class));
        Integer i2 = (Integer)injector.getInstance(Key.get(Integer.class, (Annotation)marker));
        OptionalBinderTest.assertSame((Object)i1, (Object)i2);
        OptionalBinderTest.assertEquals((int)2, (int)i2);
    }

    public void testWeakKeySet_integration() {
        Injector parentInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"hi");
            }
        }});
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(Integer.class));
        Injector childInjector = parentInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                OptionalBinder.newOptionalBinder((Binder)this.binder(), Integer.class).setDefault().toInstance((Object)4);
            }
        }});
        WeakReference<Injector> weakRef = new WeakReference<Injector>(childInjector);
        WeakKeySetUtils.assertBanned(parentInjector, Key.get(Integer.class));
        childInjector = null;
        Asserts.awaitClear(weakRef);
        WeakKeySetUtils.assertNotBanned(parentInjector, Key.get(Integer.class));
    }

    public void testCompareEqualsAgainstOtherAnnotation() {
        RealOptionalBinder.ActualImpl impl1 = new RealOptionalBinder.ActualImpl("foo");
        RealOptionalBinder.Actual other1 = Dummy.class.getAnnotation(RealOptionalBinder.Actual.class);
        OptionalBinderTest.assertEquals((Object)impl1, (Object)other1);
        RealOptionalBinder.DefaultImpl impl2 = new RealOptionalBinder.DefaultImpl("foo");
        RealOptionalBinder.Default other2 = Dummy.class.getAnnotation(RealOptionalBinder.Default.class);
        OptionalBinderTest.assertEquals((Object)impl2, (Object)other2);
        OptionalBinderTest.assertFalse((boolean)impl1.equals(impl2));
        OptionalBinderTest.assertFalse((boolean)impl1.equals(other2));
        OptionalBinderTest.assertFalse((boolean)impl2.equals(other1));
        OptionalBinderTest.assertFalse((boolean)other1.equals(other2));
    }

    private static String getShortName(Module module) {
        String fullName = module.getClass().getName();
        return fullName.substring(fullName.lastIndexOf(".") + 1);
    }

    private <V> Set<V> setOf(V ... elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    private static /* synthetic */ void lambda$testLinkedTypeSameAsBaseType$0(Module module) throws Throwable {
        Guice.createInjector((Module[])new Module[]{module});
    }

    static class MyClass {
        MyClass() {
        }
    }

    @RealOptionalBinder.Actual(value="foo")
    @RealOptionalBinder.Default(value="foo")
    static class Dummy {
        Dummy() {
        }
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Marker {
    }

    private static class StringGrabber {
        private final String string;

        public StringGrabber(@Named(value="A_string") String string) {
            this.string = string;
        }

        public StringGrabber(@Named(value="B_string") String string, int unused) {
            this.string = string;
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof StringGrabber && ((StringGrabber)obj).string.equals(this.string);
        }

        public String toString() {
            return "StringGrabber(" + this.string + ")";
        }
    }

    private static class BStringProvider
    implements Provider<String> {
        private BStringProvider() {
        }

        public String get() {
            return "B";
        }
    }

    private static class AStringProvider
    implements Provider<String> {
        private AStringProvider() {
        }

        public String get() {
            return "A";
        }
    }

    private static class DependsOnJitBinding {
        @Inject
        DependsOnJitBinding(JitBinding jitBinding) {
        }
    }

    private static class JitBinding {
        @Inject
        JitBinding() {
        }
    }
}

