/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.internal.ConstructionProxy;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.MethodAspect;
import com.google.inject.internal.ProxyFactory;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionPoint;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProxyFactoryTest {
    List<MethodAspect> aspects = Lists.newArrayList();

    @Test
    public void testSimpleCase() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        InjectionPoint injectionPoint = InjectionPoint.forConstructorOf(Simple.class);
        this.aspects.add(new MethodAspect(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor}));
        ProxyFactory factory = new ProxyFactory(injectionPoint, this.aspects);
        ConstructionProxy constructionProxy = factory.create();
        Simple simple = (Simple)constructionProxy.newInstance(new Object[0]);
        simple.invoke();
        Assert.assertTrue((boolean)simple.invoked);
        Assert.assertTrue((boolean)interceptor.invoked);
    }

    @Test
    public void testInterceptOneMethod() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        this.aspects.add(new MethodAspect(Matchers.only(Bar.class), Matchers.annotatedWith(Intercept.class), new MethodInterceptor[]{interceptor}));
        ConstructionProxy fooFactory = new ProxyFactory(InjectionPoint.forConstructorOf(Foo.class), this.aspects).create();
        ConstructionProxy barFactory = new ProxyFactory(InjectionPoint.forConstructorOf(Bar.class), this.aspects).create();
        Foo foo = (Foo)fooFactory.newInstance(new Object[0]);
        Bar bar = (Bar)barFactory.newInstance(new Object[0]);
        foo.foo();
        Assert.assertTrue((boolean)foo.fooCalled);
        Assert.assertFalse((boolean)interceptor.invoked);
        bar.bar();
        Assert.assertTrue((boolean)bar.barCalled);
        Assert.assertFalse((boolean)interceptor.invoked);
        bar.intercepted();
        Assert.assertTrue((boolean)bar.interceptedCalled);
        Assert.assertTrue((boolean)interceptor.invoked);
    }

    @Test
    public void testWithConstructorArguments() throws InvocationTargetException, NoSuchMethodException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        this.aspects.add(new MethodAspect(Matchers.any(), Matchers.any(), new MethodInterceptor[]{interceptor}));
        ProxyFactory factory = new ProxyFactory(InjectionPoint.forConstructorOf(A.class), this.aspects);
        ConstructionProxy constructor = factory.create();
        A a = (A)constructor.newInstance(new Object[]{5});
        a.a();
        Assert.assertEquals((long)5L, (long)a.i);
    }

    @Test
    public void testNotProxied() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        SimpleInterceptor interceptor = new SimpleInterceptor();
        this.aspects.add(new MethodAspect(Matchers.not((Matcher)Matchers.any()), Matchers.not((Matcher)Matchers.any()), new MethodInterceptor[]{interceptor}));
        ProxyFactory factory = new ProxyFactory(InjectionPoint.forConstructorOf(A.class), this.aspects);
        ConstructionProxy constructor = factory.create();
        A a = (A)constructor.newInstance(new Object[]{5});
        Assert.assertEquals(A.class, a.getClass());
    }

    @Test
    public void testMultipleInterceptors() throws NoSuchMethodException, InvocationTargetException, ErrorsException {
        DoubleInterceptor doubleInterceptor = new DoubleInterceptor();
        CountingInterceptor countingInterceptor = new CountingInterceptor();
        this.aspects.add(new MethodAspect(Matchers.any(), Matchers.any(), new MethodInterceptor[]{doubleInterceptor, countingInterceptor}));
        ProxyFactory factory = new ProxyFactory(InjectionPoint.forConstructorOf(Counter.class), this.aspects);
        ConstructionProxy constructor = factory.create();
        Counter counter = (Counter)constructor.newInstance(new Object[0]);
        counter.inc();
        Assert.assertEquals((long)2L, (long)counter.count);
        Assert.assertEquals((long)2L, (long)countingInterceptor.count);
    }

    public static class Counter {
        int count;

        protected void inc() {
            ++this.count;
        }
    }

    static class DoubleInterceptor
    implements MethodInterceptor {
        DoubleInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            methodInvocation.proceed();
            return methodInvocation.proceed();
        }
    }

    static class CountingInterceptor
    implements MethodInterceptor {
        int count;

        CountingInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            ++this.count;
            return methodInvocation.proceed();
        }
    }

    public static class A {
        final int i;

        @Inject
        public A(int i) {
            this.i = i;
        }

        public void a() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Intercept {
    }

    public static class Bar {
        boolean barCalled;
        boolean interceptedCalled;

        protected void bar() {
            this.barCalled = true;
        }

        @Intercept
        protected void intercepted() {
            this.interceptedCalled = true;
        }
    }

    public static class Foo {
        boolean fooCalled;

        @Intercept
        protected void foo() {
            this.fooCalled = true;
        }
    }

    static class SimpleInterceptor
    implements MethodInterceptor {
        boolean invoked = false;

        SimpleInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            this.invoked = true;
            return methodInvocation.proceed();
        }
    }

    public static class Simple {
        boolean invoked = false;

        public void invoke() {
            this.invoked = true;
        }
    }
}

