/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.aop;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.internal.aop.ImmutableStringTrie;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ImmutableStringTrieTest
extends TestCase {
    private static final int NUM_TEST_STRINGS = 65536;
    private static final int MAX_STRING_LENGTH = 100;

    public void testSingletonTrie() {
        ToIntFunction trie = ImmutableStringTrie.buildTrie((Collection)ImmutableSet.of((Object)"testKey"));
        Assert.assertThat((Object)trie.applyAsInt("testKey"), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testMethodStrings() {
        List table = Arrays.stream(Binder.class.getDeclaredMethods()).map(Method::toString).collect(Collectors.toList());
        Collections.sort(table);
        ToIntFunction trie = ImmutableStringTrie.buildTrie(table);
        for (int i = 0; i < table.size(); ++i) {
            Assert.assertThat((Object)trie.applyAsInt(table.get(i)), (Matcher)CoreMatchers.is((Object)i));
        }
    }

    public void testRandomStrings() {
        SecureRandom random = new SecureRandom();
        StringBuilder buf = new StringBuilder();
        TreeSet<String> strings = new TreeSet<String>();
        while (strings.size() < 65536) {
            ImmutableStringTrieTest.randomize(random, buf);
            strings.add(buf.toString());
            buf.setLength(0);
        }
        ArrayList table = new ArrayList(strings);
        ToIntFunction trie = ImmutableStringTrie.buildTrie(table);
        for (int i = 0; i < table.size(); ++i) {
            Assert.assertThat((Object)trie.applyAsInt(table.get(i)), (Matcher)CoreMatchers.is((Object)i));
        }
    }

    private static void randomize(Random random, StringBuilder buf) {
        int length = random.nextInt(100) + 1;
        while (buf.length() < length) {
            char c = (char)random.nextInt(65536);
            if (Character.isSurrogate(c)) continue;
            buf.append(c);
        }
    }
}

