/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Module;
import com.google.inject.internal.InternalFlags;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.Elements;
import com.google.inject.spi.ModuleSource;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import junit.framework.TestCase;

public class ElementSourceTest
extends TestCase {
    private static final StackTraceElement BINDER_INSTALL = new StackTraceElement("com.google.inject.spi.Elements$RecordingBinder", "install", "Unknown Source", 234);

    public void testCallStackSize() {
        ModuleSource moduleSource = this.createModuleSource();
        StackTraceElement[] bindingCallStack = new StackTraceElement[]{new StackTraceElement("com.google.inject.spi.Elements$RecordingBinder", "bind", "Unknown Source", 200), new StackTraceElement("com.google.inject.spi.Elements$RecordingBinder", "bind", "Unknown Source", 100), new StackTraceElement("com.google.inject.spi.moduleSourceTest$C", "configure", "Unknown Source", 100)};
        ElementSource elementSource = new ElementSource(null, false, (Object)"", moduleSource, bindingCallStack, null);
        ElementSourceTest.assertEquals((int)10, (int)elementSource.getStackTrace().length);
    }

    public void testGetCallStack_IntegrationTest() throws Exception {
        List elements = Elements.getElements((Module[])new Module[]{new A()});
        for (Element element : elements) {
            Binding binding;
            Class annotationType;
            if (!(element instanceof Binding) || (annotationType = (binding = (Binding)element).getKey().getAnnotationType()) == null || !annotationType.equals(SampleAnnotation.class)) continue;
            ElementSource elementSource = (ElementSource)binding.getSource();
            List moduleClassNames = elementSource.getModuleClassNames();
            ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$C", (String)((String)moduleClassNames.get(0)));
            ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$B", (String)((String)moduleClassNames.get(1)));
            ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$A", (String)((String)moduleClassNames.get(2)));
            StackTraceElement[] callStack = elementSource.getStackTrace();
            switch (InternalFlags.getIncludeStackTraceOption()) {
                case OFF: {
                    StackTraceElement stackTraceElement = (StackTraceElement)elementSource.getDeclaringSource();
                    ElementSourceTest.assertEquals((Object)new StackTraceElement("com.google.inject.spi.ElementSourceTest$C", "configure", null, -1), (Object)stackTraceElement);
                    ElementSourceTest.assertEquals((int)0, (int)callStack.length);
                    return;
                }
                case ONLY_FOR_DECLARING_SOURCE: {
                    ElementSourceTest.assertEquals((int)0, (int)callStack.length);
                    return;
                }
                case COMPLETE: {
                    int skippedCallStackSize = new Throwable().getStackTrace().length - 1;
                    ElementSourceTest.assertEquals((int)(skippedCallStackSize + 15), (int)elementSource.getStackTrace().length);
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.Elements$RecordingBinder", (String)callStack[0].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.Elements$RecordingBinder", (String)callStack[1].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.AbstractModule", (String)callStack[2].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$C", (String)callStack[3].getClassName());
                    ElementSourceTest.assertEquals((String)"configure", (String)callStack[3].getMethodName());
                    ElementSourceTest.assertEquals((String)"Unknown Source", (String)callStack[3].getFileName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.AbstractModule", (String)callStack[4].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.Elements$RecordingBinder", (String)callStack[5].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$B", (String)callStack[6].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.Elements$RecordingBinder", (String)callStack[7].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.AbstractModule", (String)callStack[8].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$A", (String)callStack[9].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.AbstractModule", (String)callStack[10].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.Elements$RecordingBinder", (String)callStack[11].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.Elements", (String)callStack[12].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.Elements", (String)callStack[13].getClassName());
                    ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest", (String)callStack[14].getClassName());
                    List indexes = elementSource.getModuleConfigurePositionsInStackTrace();
                    ElementSourceTest.assertEquals((int)4, (int)((Integer)indexes.get(0)));
                    ElementSourceTest.assertEquals((int)6, (int)((Integer)indexes.get(1)));
                    ElementSourceTest.assertEquals((int)10, (int)((Integer)indexes.get(2)));
                    return;
                }
            }
        }
        ElementSourceTest.fail((String)"The test should not reach this line.");
    }

    private ModuleSource createModuleSource() {
        StackTraceElement[] partialCallStack = new StackTraceElement[]{BINDER_INSTALL};
        ModuleSource moduleSource = new ModuleSource(A.class, partialCallStack, null);
        partialCallStack = new StackTraceElement[]{BINDER_INSTALL, new StackTraceElement("com.google.inject.spi.moduleSourceTest$A", "configure", "Unknown Source", 100)};
        moduleSource = moduleSource.createChild(B.class, partialCallStack);
        partialCallStack = new StackTraceElement[]{BINDER_INSTALL, new StackTraceElement("class1", "method1", "Class1.java", 1), new StackTraceElement("class2", "method2", "Class2.java", 2), new StackTraceElement("com.google.inject.spi.moduleSourceTest$B", "configure", "Unknown Source", 200)};
        return moduleSource.createChild(C.class, partialCallStack);
    }

    private static class C
    extends AbstractModule {
        private C() {
        }

        public void configure() {
            this.bind(String.class).annotatedWith(SampleAnnotation.class).toInstance((Object)"the value");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface SampleAnnotation {
    }

    private static class B
    implements Module {
        private B() {
        }

        public void configure(Binder binder) {
            binder.install((Module)new C());
        }
    }

    private static class A
    extends AbstractModule {
        private A() {
        }

        public void configure() {
            this.install(new B());
        }
    }
}

