/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Exposed;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.internal.ProviderMethodsModule;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Set;
import javax.inject.Qualifier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ModuleAnnotatedMethodScannerTest {
    @Test
    public void scanning() throws Exception {
        AbstractModule module = new AbstractModule(){

            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }

            @TestProvides
            @Named(value="foo2")
            String foo2() {
                return "foo2";
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module, ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger())});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
        this.assertMungedBinding(injector, String.class, "foo2", "foo2");
        Binding fooBinding = injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"foo-munged")));
        Binding foo2Binding = injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"foo2-munged")));
        Truth.assertThat((String)this.methodName(TestProvides.class, "foo", module)).isEqualTo((Object)fooBinding.getProvider().toString());
        Truth.assertThat((String)this.methodName(TestProvides.class, "foo2", module)).isEqualTo((Object)foo2Binding.getProvider().toString());
    }

    @Test
    public void skipSources() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new AbstractModule(){

                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module, ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger())});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void withSource() throws Exception {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.binder().withSource((Object)"source").install((Module)new AbstractModule(){

                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module, ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger())});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void moreThanOneClaimedAnnotationFails() throws Exception {
        AbstractModule module = new AbstractModule(){

            @TestProvides
            @TestProvides2
            String foo() {
                return "foo";
            }
        };
        CreationException creationException = this.assertThatInjectorCreationFails(new Module[]{module, ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger())});
        Truth.assertThat((Iterable)creationException.getErrorMessages()).hasSize(1);
        Truth.assertThat((Throwable)creationException).hasMessageThat().contains((CharSequence)"More than one annotation claimed by NamedMunger on method ModuleAnnotatedMethodScannerTest$4.foo(). Methods can only have one annotation claimed per scanner.");
    }

    private String methodName(Class<? extends Annotation> annotation, String method, Object container) throws Exception {
        return "@" + annotation.getName() + " " + StackTraceElements.forMember((Member)container.getClass().getDeclaredMethod(method, new Class[0]));
    }

    private void assertMungedBinding(Injector injector, Class<?> clazz, String originalName, Object expectedValue) {
        Truth.assertThat((Object)injector.getExistingBinding(Key.get(clazz, (Annotation)Names.named((String)originalName)))).isNull();
        Binding fooBinding = injector.getBinding(Key.get(clazz, (Annotation)Names.named((String)(originalName + "-munged"))));
        Truth.assertThat((Object)fooBinding.getProvider().get()).isEqualTo(expectedValue);
    }

    @Test
    public void failingScanner() {
        CreationException creationException = this.assertThatInjectorCreationFails(new Module[]{new SomeModule(), ModuleAnnotatedMethodScannerTest.scannerModule(new FailingScanner())});
        Message m = (Message)Iterables.getOnlyElement((Iterable)creationException.getErrorMessages());
        Truth.assertThat((String)m.getMessage()).isEqualTo((Object)"An exception was caught and reported. Message: Failing in the scanner.");
        Truth.assertThat((Throwable)creationException).hasCauseThat().isInstanceOf(IllegalStateException.class);
        ElementSource source = (ElementSource)Iterables.getOnlyElement((Iterable)m.getSources());
        Truth.assertThat((String)SomeModule.class.getName()).isEqualTo(Iterables.getOnlyElement((Iterable)source.getModuleClassNames()));
        Truth.assertThat((String)(String.class.getName() + " " + SomeModule.class.getName() + ".aString()")).isEqualTo((Object)source.toString());
    }

    @Test
    public void sannerFailureDoesNotPropagateDownstream() {
        AbstractModule module = new AbstractModule(){

            @TestProvides
            @Named(value="foo")
            String provideFoo() {
                return "FOO";
            }

            @Provides
            @Named(value="bar")
            String providesBar(@Named(value="foo") String foo) {
                return "uses " + foo;
            }
        };
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> ModuleAnnotatedMethodScannerTest.lambda$sannerFailureDoesNotPropagateDownstream$0((Module)module));
        Truth.assertThat((Iterable)exception.getErrorMessages()).hasSize(1);
    }

    @Test
    public void childInjectorInheritsScanner() {
        Injector parent = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger())});
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }});
        this.assertMungedBinding(child, String.class, "foo", "foo");
    }

    @Test
    public void childInjectorScannersDontImpactSiblings() {
        AbstractModule module = new AbstractModule(){

            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        };
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), module});
        this.assertMungedBinding(child, String.class, "foo", "foo");
        Injector sibling = parent.createChildInjector(new Module[]{module});
        Truth.assertThat((Object)sibling.getExistingBinding(Key.get(String.class, (Annotation)Names.named((String)"foo")))).isNull();
        Truth.assertThat((Object)sibling.getExistingBinding(Key.get(String.class, (Annotation)Names.named((String)"foo-munged")))).isNull();
    }

    @Test
    public void privateModuleInheritScanner_usingPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), new PrivateModule(){

            protected void configure() {
            }

            @Exposed
            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleInheritsScanner_scannerInstalledAfterPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            protected void configure() {
            }

            @Exposed
            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }, ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger())});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModule_skipSourcesWithinPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), new PrivateModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new AbstractModule(){

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModule_skipSourcesForPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), new AbstractModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new PrivateModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleInheritScanner_usingPrivateBinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().install((Module)new AbstractModule(){

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleInheritScanner_skipSourcesFromPrivateBinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).install((Module)new AbstractModule(){

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleInheritScanner_skipSourcesFromPrivateBinder2() {
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), new AbstractModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).newPrivateBinder().install((Module)new AbstractModule(){

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleScannersDontImpactSiblings_usingPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            protected void configure() {
                this.install(ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()));
            }

            @Exposed
            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }, new PrivateModule(){

            protected void configure() {
            }

            @Exposed
            @TestProvides
            @Named(value="foo")
            String foo() {
                return "foo";
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleScannersDontImpactSiblings_usingPrivateBinder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().install((Module)new AbstractModule(){

                    protected void configure() {
                        this.install(ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()));
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }, new AbstractModule(){

            protected void configure() {
                this.binder().newPrivateBinder().install((Module)new AbstractModule(){

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleWithinPrivateModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger()), new PrivateModule(){

            protected void configure() {
                this.expose(Key.get(String.class, (Annotation)Names.named((String)"foo-munged")));
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void privateModuleWithinPrivateModule_parentScannerInheritedIfInstalledAfter() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PrivateModule(){

            protected void configure() {
                this.expose(Key.get(String.class, (Annotation)Names.named((String)"foo-munged")));
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Named(value="foo")
                    String foo() {
                        return "foo";
                    }
                });
            }
        }, ModuleAnnotatedMethodScannerTest.scannerModule(new NamedMunger())});
        this.assertMungedBinding(injector, String.class, "foo", "foo");
    }

    @Test
    public void abstractMethodsAreScannedForOverrides() {
        ModuleAnnotatedMethodScanner testScanner = new ModuleAnnotatedMethodScanner(){

            public Set<? extends Class<? extends Annotation>> annotationClasses() {
                return ImmutableSet.of(TestProvides.class);
            }

            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                return null;
            }
        };
        abstract class Subclass
        extends 1Superclass {
            Subclass() {
                abstract class Superclass {
                    Superclass() {
                    }

                    @TestProvides
                    abstract boolean abstractTest();
                }
            }

            @Override
            @TestProvides
            abstract boolean abstractTest();
        }
        CreationException creationException = this.assertThatInjectorCreationFails(ProviderMethodsModule.forModule(Subclass.class, (ModuleAnnotatedMethodScanner)testScanner));
        Truth.assertThat((Throwable)creationException).hasMessageThat().contains((CharSequence)"Overriding @ModuleAnnotatedMethodScannerTest.TestProvides methods is not allowed.");
    }

    @Test
    public void ignoreMethodsScannedForOverridesSubclass() {
        IgnoringScanner scanner = new IgnoringScanner(Subclass.class);
        CreationException creationException = this.assertThatInjectorCreationFails(ProviderMethodsModule.forModule((Object)new Subclass(), (ModuleAnnotatedMethodScanner)scanner));
        Truth.assertThat((Throwable)creationException).hasMessageThat().contains((CharSequence)"Overriding @ModuleAnnotatedMethodScannerTest.TestProvides methods is not allowed.");
        Truth.assertThat((Integer)scanner.ignoredCounter()).isEqualTo((Object)1);
    }

    @Test
    public void ignoreMethodsScannedForOverridesSuperclass() {
        IgnoringScanner scanner = new IgnoringScanner(Superclass.class);
        CreationException creationException = this.assertThatInjectorCreationFails(ProviderMethodsModule.forModule((Object)new Subclass(), (ModuleAnnotatedMethodScanner)scanner));
        Truth.assertThat((Throwable)creationException).hasMessageThat().contains((CharSequence)"Overriding @ModuleAnnotatedMethodScannerTest.TestProvides methods is not allowed.");
        Truth.assertThat((Integer)scanner.ignoredCounter()).isEqualTo((Object)1);
    }

    @Test
    public void ignoreMethods() {
        TestScanner filteringScanner = new TestScanner(new Class[]{TestProvides.class}){

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                Method method = (Method)injectionPoint.getMember();
                if (method.getName().equals("ignore")) {
                    return null;
                }
                return key;
            }
        };
        class ModuleWithMethodsToIgnore {
            ModuleWithMethodsToIgnore() {
            }

            @TestProvides
            boolean booleanTest() {
                return true;
            }

            @TestProvides
            int ignore() {
                return 0;
            }
        }
        Injector filteredInjector = Guice.createInjector((Module[])new Module[]{ProviderMethodsModule.forModule((Object)new ModuleWithMethodsToIgnore(), (ModuleAnnotatedMethodScanner)filteringScanner)});
        Truth.assertThat((Boolean)((Boolean)filteredInjector.getInstance(Key.get(Boolean.class)))).isTrue();
        Assert.assertThrows(ConfigurationException.class, () -> {
            Integer cfr_ignored_0 = (Integer)filteredInjector.getInstance(Integer.class);
        });
        Injector unfilteredInjector = Guice.createInjector((Module[])new Module[]{ProviderMethodsModule.forModule((Object)new ModuleWithMethodsToIgnore(), (ModuleAnnotatedMethodScanner)new TestScanner(TestProvides.class))});
        Truth.assertThat((Boolean)((Boolean)unfilteredInjector.getInstance(Key.get(Boolean.class)))).isTrue();
        Truth.assertThat((Integer)((Integer)unfilteredInjector.getInstance(Integer.class))).isEqualTo((Object)0);
    }

    @Test
    public void scannerCantRegisterScanner() {
        TestScanner scannerRegisteringScanner = new TestScanner(new Class[]{TestProvides.class}){

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.scanModulesForAnnotatedMethods((ModuleAnnotatedMethodScanner)new TestScanner(TestProvides2.class));
                return key;
            }
        };
        CreationException creationException = this.assertThatInjectorCreationFails(new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(scannerRegisteringScanner), new AbstractModule(){

            @TestProvides
            boolean bogus() {
                return true;
            }
        }});
        Truth.assertThat((Throwable)creationException).hasMessageThat().contains((CharSequence)"Scanners are not allowed to register other scanners");
    }

    @Test
    public void scannerCantInstallModuleWithCustomProvidesMethods() {
        TestScanner scannerInstallingScannableModule = new TestScanner(new Class[]{TestProvides.class}){

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.install((Module)new AbstractModule(){

                    @TestProvides2
                    int bogus() {
                        return 0;
                    }
                });
                return key;
            }
        };
        CreationException creationException = this.assertThatInjectorCreationFails(new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(scannerInstallingScannableModule), ModuleAnnotatedMethodScannerTest.scannerModule(new TestScanner(TestProvides2.class)), new AbstractModule(){

            @TestProvides
            boolean bogus() {
                return true;
            }
        }});
        Truth.assertThat((Throwable)creationException).hasMessageThat().contains((CharSequence)"Installing modules with custom provides methods from a ModuleAnnotatedMethodScanner is not supported");
    }

    @Test
    public void scannerCantInstallPrivateModuleWithCustomProvidesMethods() {
        TestScanner scannerInstallingScannablePrivateModule = new TestScanner(new Class[]{TestProvides.class}){

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.install((Module)new PrivateModule(){

                    protected void configure() {
                    }

                    @TestProvides2
                    int bogus() {
                        return 0;
                    }
                });
                return key;
            }
        };
        CreationException creationException = this.assertThatInjectorCreationFails(new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(scannerInstallingScannablePrivateModule), ModuleAnnotatedMethodScannerTest.scannerModule(new TestScanner(TestProvides2.class)), new AbstractModule(){

            @TestProvides
            boolean bogus() {
                return true;
            }
        }});
        Truth.assertThat((Throwable)creationException).hasMessageThat().contains((CharSequence)"Installing modules with custom provides methods from a ModuleAnnotatedMethodScanner is not supported");
    }

    @Test
    public void scannerCanInstallModuleWithRegularProvidesMethods() {
        TestScanner scanner = new TestScanner(new Class[]{TestProvides.class}){

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.install((Module)new AbstractModule(){

                    @Provides
                    int provideAnswer() {
                        return 42;
                    }
                });
                return key;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ModuleAnnotatedMethodScannerTest.scannerModule(scanner), new AbstractModule(){

            @TestProvides
            boolean bogus() {
                return true;
            }
        }});
        Truth.assertThat((Integer)((Integer)injector.getInstance(Integer.class))).isEqualTo((Object)42);
    }

    CreationException assertThatInjectorCreationFails(Module ... modules) {
        return (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])modules));
    }

    @Test
    public void scannerSourceCorrectForNonGuiceModule() {
        TestScanner testScanner = new TestScanner(TestProvides.class);
        class NonGuiceModule {
            NonGuiceModule() {
            }

            @TestProvides
            boolean booleanTest() {
                return true;
            }
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{ProviderMethodsModule.forModule((Object)new NonGuiceModule(), (ModuleAnnotatedMethodScanner)testScanner)});
        Truth.assertThat((Object)this.getSourceScanner(injector.getBinding(Boolean.class))).isEqualTo((Object)testScanner);
    }

    @Test
    public void scannerSourceCorrectForGuiceModule() {
        AbstractModule module = new AbstractModule(){

            @TestProvides
            @Foo
            boolean booleanTest() {
                return true;
            }

            @Provides
            String stringTest() {
                return "";
            }

            protected void configure() {
                this.bind(Long.class).toInstance((Object)1L);
            }
        };
        TestScanner testScanner = new TestScanner(TestProvides.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{module, ModuleAnnotatedMethodScannerTest.scannerModule(testScanner)});
        Truth.assertThat((Object)this.getSourceScanner(injector.getBinding(Key.get(Boolean.class, Foo.class)))).isEqualTo((Object)testScanner);
        Truth.assertThat((Object)this.getSourceScanner(injector.getBinding(String.class))).isNotEqualTo((Object)testScanner);
        Truth.assertThat((Object)this.getSourceScanner(injector.getBinding(Long.class))).isNull();
    }

    @Test
    public void scannerSourceCorrectForBindingsCreatedByTheScannerDirectly() {
        TestScanner scanner = new TestScanner(new Class[]{TestProvides.class}){

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.bind(key.ofType(String.class)).toInstance((Object)"bla");
                return null;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @TestProvides
            @Foo
            Long discardedLong() {
                return 1L;
            }
        }, ModuleAnnotatedMethodScannerTest.scannerModule(scanner)});
        Truth.assertThat((Object)this.getSourceScanner(injector.getBinding(Key.get(String.class, Foo.class)))).isEqualTo((Object)scanner);
    }

    @Test
    public void scannerSourceOfProvidesMethodBindingInsideCustomScannerIsCustomScanner() {
        TestScanner scanner = new TestScanner(new Class[]{TestProvides.class}){

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.install((Module)new AbstractModule(){

                    @Provides
                    String provideString() {
                        return "bla";
                    }
                });
                return null;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @TestProvides
            @Foo
            Long discardedLong() {
                return 1L;
            }
        }, ModuleAnnotatedMethodScannerTest.scannerModule(scanner)});
        Truth.assertThat((Object)this.getSourceScanner(injector.getBinding(String.class))).isEqualTo((Object)scanner);
    }

    @Test
    public void scannerSourceForPrivateModule() {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                    }

                    @Exposed
                    @TestProvides
                    @Foo
                    String privateString() {
                        return "bar";
                    }
                });
            }
        };
        TestScanner scanner = new TestScanner(TestProvides.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{module, ModuleAnnotatedMethodScannerTest.scannerModule(scanner)});
        Truth.assertThat((Object)this.getSourceScanner(injector.getBinding(Key.get(String.class, Foo.class)))).isEqualTo((Object)scanner);
    }

    ModuleAnnotatedMethodScanner getSourceScanner(Binding<?> binding) {
        return ((ElementSource)binding.getSource()).scanner;
    }

    private static Module scannerModule(final ModuleAnnotatedMethodScanner scanner) {
        return new AbstractModule(){

            protected void configure() {
                this.binder().scanModulesForAnnotatedMethods(scanner);
            }
        };
    }

    private static /* synthetic */ void lambda$sannerFailureDoesNotPropagateDownstream$0(Module module) throws Throwable {
        Guice.createInjector((Module[])new Module[]{module, ModuleAnnotatedMethodScannerTest.scannerModule(new FailingScanner())});
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Foo {
    }

    static class TestScanner
    extends ModuleAnnotatedMethodScanner {
        ImmutableSet<Class<? extends Annotation>> annotations;

        TestScanner(Class<? extends Annotation> ... annotations) {
            this.annotations = ImmutableSet.copyOf((Object[])annotations);
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return this.annotations;
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            return key;
        }
    }

    static class IgnoringScanner
    extends ModuleAnnotatedMethodScanner {
        private final Class<?> classToIgnore;
        private int ignoredCounter = 0;

        IgnoringScanner(Class<?> classToIgnore) {
            this.classToIgnore = classToIgnore;
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(TestProvides.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            Method method = (Method)injectionPoint.getMember();
            if (method.getDeclaringClass().equals(this.classToIgnore)) {
                ++this.ignoredCounter;
                return null;
            }
            return key;
        }

        int ignoredCounter() {
            return this.ignoredCounter;
        }
    }

    static class Subclass
    extends Superclass {
        Subclass() {
        }

        @Override
        @TestProvides
        boolean booleanTest() {
            return true;
        }
    }

    static class Superclass {
        Superclass() {
        }

        @TestProvides
        boolean booleanTest() {
            return true;
        }
    }

    static class SomeModule
    extends AbstractModule {
        SomeModule() {
        }

        @TestProvides
        String aString() {
            return "Foo";
        }
    }

    public static class FailingScanner
    extends ModuleAnnotatedMethodScanner {
        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(TestProvides.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation rawAnnotation, Key<T> key, InjectionPoint injectionPoint) {
            throw new IllegalStateException("Failing in the scanner.");
        }
    }

    private static class NamedMunger
    extends ModuleAnnotatedMethodScanner {
        private NamedMunger() {
        }

        public String toString() {
            return "NamedMunger";
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(TestProvides.class, TestProvides2.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            return key.withAnnotation((Annotation)Names.named((String)(((Named)key.getAnnotation()).value() + "-munged")));
        }
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestProvides2 {
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestProvides {
    }
}

