/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.ModuleSource;
import junit.framework.TestCase;

public class ModuleSourceTest
extends TestCase {
    private static final StackTraceElement BINDER_INSTALL = new StackTraceElement("com.google.inject.spi.Elements$RecordingBinder", "install", "Unknown Source", 235);

    public void testOneModule() {
        ModuleSource moduleSource = this.createWithSizeOne();
        this.checkSizeOne(moduleSource);
    }

    public void testTwoModules() {
        ModuleSource moduleSource = this.createWithSizeTwo();
        this.checkSizeTwo(moduleSource);
        moduleSource = moduleSource.getParent();
        this.checkSizeOne(moduleSource);
    }

    public void testThreeModules() {
        ModuleSource moduleSource = this.createWithSizeThree();
        this.checkSizeThree(moduleSource);
        moduleSource = moduleSource.getParent();
        this.checkSizeTwo(moduleSource);
        moduleSource = moduleSource.getParent();
        this.checkSizeOne(moduleSource);
    }

    private void checkSizeOne(ModuleSource moduleSource) {
        ModuleSourceTest.assertEquals((int)1, (int)moduleSource.size());
        ModuleSourceTest.assertEquals((int)1, (int)moduleSource.getStackTraceSize());
        StackTraceElement[] callStack = moduleSource.getStackTrace();
        ModuleSourceTest.assertEquals((Object)BINDER_INSTALL, (Object)callStack[0]);
    }

    private void checkSizeTwo(ModuleSource moduleSource) {
        ModuleSourceTest.assertEquals((int)2, (int)moduleSource.size());
        ModuleSourceTest.assertEquals((int)3, (int)moduleSource.getStackTraceSize());
        StackTraceElement[] callStack = moduleSource.getStackTrace();
        ModuleSourceTest.assertEquals((Object)BINDER_INSTALL, (Object)callStack[0]);
        ModuleSourceTest.assertEquals((Object)new StackTraceElement("com.google.inject.spi.moduleSourceTest$A", "configure", "Unknown Source", 100), (Object)callStack[1]);
        ModuleSourceTest.assertEquals((Object)BINDER_INSTALL, (Object)callStack[2]);
    }

    private void checkSizeThree(ModuleSource moduleSource) {
        ModuleSourceTest.assertEquals((int)3, (int)moduleSource.size());
        ModuleSourceTest.assertEquals((int)7, (int)moduleSource.getStackTraceSize());
        StackTraceElement[] callStack = moduleSource.getStackTrace();
        ModuleSourceTest.assertEquals((Object)BINDER_INSTALL, (Object)callStack[0]);
        ModuleSourceTest.assertEquals((Object)new StackTraceElement("class1", "method1", "Unknown Source", 1), (Object)callStack[1]);
        ModuleSourceTest.assertEquals((Object)new StackTraceElement("class2", "method2", "Unknown Source", 2), (Object)callStack[2]);
        ModuleSourceTest.assertEquals((Object)new StackTraceElement("com.google.inject.spi.moduleSourceTest$B", "configure", "Unknown Source", 200), (Object)callStack[3]);
        ModuleSourceTest.assertEquals((Object)BINDER_INSTALL, (Object)callStack[4]);
        ModuleSourceTest.assertEquals((Object)new StackTraceElement("com.google.inject.spi.moduleSourceTest$A", "configure", "Unknown Source", 100), (Object)callStack[5]);
        ModuleSourceTest.assertEquals((Object)BINDER_INSTALL, (Object)callStack[6]);
    }

    private ModuleSource createWithSizeOne() {
        StackTraceElement[] partialCallStack = new StackTraceElement[]{BINDER_INSTALL};
        return new ModuleSource(A.class, partialCallStack, null);
    }

    private ModuleSource createWithSizeTwo() {
        ModuleSource moduleSource = this.createWithSizeOne();
        StackTraceElement[] partialCallStack = new StackTraceElement[]{BINDER_INSTALL, new StackTraceElement("com.google.inject.spi.moduleSourceTest$A", "configure", "moduleSourceTest.java", 100)};
        return moduleSource.createChild(B.class, partialCallStack);
    }

    private ModuleSource createWithSizeThree() {
        ModuleSource moduleSource = this.createWithSizeTwo();
        StackTraceElement[] partialCallStack = new StackTraceElement[]{BINDER_INSTALL, new StackTraceElement("class1", "method1", "Class1.java", 1), new StackTraceElement("class2", "method2", "Class2.java", 2), new StackTraceElement("com.google.inject.spi.moduleSourceTest$B", "configure", "moduleSourceTest.java", 200)};
        return moduleSource.createChild(C.class, partialCallStack);
    }

    private static class C
    extends AbstractModule {
        private C() {
        }
    }

    private static class B
    implements Module {
        private B() {
        }

        public void configure(Binder binder) {
            binder.install((Module)new C());
        }
    }

    private static class A
    extends AbstractModule {
        private A() {
        }

        public void configure() {
            this.install(new B());
        }
    }
}

