/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj.internal;

import io.freefair.gradle.plugins.aspectj.AspectjSourceDirectorySet;
import io.freefair.gradle.plugins.aspectj.AspectjSourceSet;
import io.freefair.gradle.plugins.aspectj.internal.DefaultAspectjSourceDirectorySet;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;

public class DefaultAspectjSourceSet
implements AspectjSourceSet,
HasPublicType {
    public DefaultAspectjSourceSet(ObjectFactory objectFactory, SourceSet sourceSet) {
        String name = sourceSet.getName();
        String displayName = ((DefaultSourceSet)sourceSet).getDisplayName();
        AspectjSourceDirectorySet aspectj = DefaultAspectjSourceSet.createAspectjSourceDirectorySet(name, displayName, objectFactory);
        aspectj.getFilter().include(new String[]{"**/*.java", "**/*.aj"});
        SourceDirectorySet allAspectj = objectFactory.sourceDirectorySet("all" + name, displayName + " AspectJ source");
        allAspectj.source((SourceDirectorySet)aspectj);
        allAspectj.getFilter().include(new String[]{"**/*.aj"});
        sourceSet.getExtensions().add("aspectj", (Object)aspectj);
        sourceSet.getExtensions().add("allAspectj", (Object)allAspectj);
    }

    private static AspectjSourceDirectorySet createAspectjSourceDirectorySet(String name, String displayName, ObjectFactory objectFactory) {
        AspectjSourceDirectorySet aspectjSourceDirectorySet = (AspectjSourceDirectorySet)objectFactory.newInstance(DefaultAspectjSourceDirectorySet.class, new Object[]{objectFactory.sourceDirectorySet(name, displayName + " AspectJ source")});
        aspectjSourceDirectorySet.getFilter().include(new String[]{"**/*.java", "**/*.aj"});
        return aspectjSourceDirectorySet;
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(AspectjSourceSet.class);
    }
}

