/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJCompileOptions;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompileSpec;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompiler;
import io.freefair.gradle.util.TaskUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.jetbrains.kotlin.gradle.dsl.JvmTarget;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions;
import org.jetbrains.kotlin.gradle.tasks.KotlinJvmCompile;

public class AjcAction
implements Action<Task> {
    private final ProjectLayout projectLayout;
    private final ExecOperations execOperations;
    private final ConfigurableFileCollection classpath;
    private final Property<Boolean> enabled;
    private final AspectJCompileOptions options;
    private final ConfigurableFileCollection additionalInpath;
    @Nested
    @Optional
    private final Property<JavaLauncher> launcher;

    public void options(Action<AspectJCompileOptions> action) {
        action.execute((Object)this.getOptions());
    }

    @Inject
    public AjcAction(ProjectLayout projectLayout, ObjectFactory objectFactory, ExecOperations execOperations) {
        this.projectLayout = projectLayout;
        this.options = new AspectJCompileOptions(objectFactory);
        this.classpath = objectFactory.fileCollection();
        this.additionalInpath = objectFactory.fileCollection();
        this.launcher = objectFactory.property(JavaLauncher.class);
        this.enabled = objectFactory.property(Boolean.class).convention((Object)true);
        this.execOperations = execOperations;
    }

    public void addToTask(Task task) {
        task.doLast("ajc", (Action)this);
        task.getExtensions().add("ajc", (Object)this);
        task.getInputs().files(new Object[]{this.getClasspath()}).withPropertyName("aspectjClasspath").withNormalizer(ClasspathNormalizer.class).optional(false);
        task.getInputs().property("ajcEnabled", this.getEnabled()).optional(true);
        try {
            TaskUtils.registerNested((Task)task, AspectJCompileOptions.class, (Object)this.getOptions(), (String)"ajcOptions");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void execute(Task task) {
        if (this.shouldSkipAjc(task)) {
            return;
        }
        AspectJCompileSpec spec = this.createSpec(task);
        new AspectJCompiler(this.execOperations).execute(spec);
    }

    private boolean shouldSkipAjc(Task task) {
        boolean bl;
        if (!((Boolean)this.enabled.getOrElse((Object)true)).booleanValue()) {
            task.getLogger().lifecycle("Skipping AJC for task '{}' (disabled)", new Object[]{task.getPath()});
            return true;
        }
        if (!this.getOptions().getAspectpath().isEmpty()) {
            task.getLogger().info("Not skipping AJC (aspectpath is set)");
            return false;
        }
        if (!this.getOptions().getInpath().isEmpty()) {
            task.getLogger().info("Not skipping AJC (inpath is set)");
            return false;
        }
        if (!this.getOptions().getSourceroots().isEmpty()) {
            task.getLogger().info("Not skipping AJC (sourceroots is set)");
            return false;
        }
        URL[] cp = (URL[])AjcAction.getCompileClasspath(task).map(AjcAction::toURL).toArray(URL[]::new);
        URLClassLoader urlClassLoader = new URLClassLoader(cp);
        try {
            Class<?> clazz = urlClassLoader.loadClass("org.aspectj.lang.JoinPoint");
            task.getLogger().info("Not skipping AJC (found {} in {})", clazz, (Object)clazz.getProtectionDomain().getCodeSource().getLocation());
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    urlClassLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                task.getLogger().lifecycle("Skipping AJC for task '{}' (no inpath, no aspectpath, no aspectjrt on classpath)", new Object[]{task.getPath()});
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        urlClassLoader.close();
        return bl;
    }

    private AspectJCompileSpec createSpec(Task compile) {
        AspectJCompileSpec spec = new AspectJCompileSpec();
        if (compile instanceof AbstractCompile) {
            AbstractCompile abstractCompile = (AbstractCompile)compile;
            spec.setDestinationDir(((Directory)abstractCompile.getDestinationDirectory().get()).getAsFile());
            spec.setTargetCompatibility(abstractCompile.getTargetCompatibility());
            spec.setSourceCompatibility(abstractCompile.getSourceCompatibility());
        } else if (compile instanceof KotlinJvmCompile) {
            KotlinJvmCompile kotlinJvmCompile = (KotlinJvmCompile)compile;
            spec.setDestinationDir(((Directory)kotlinJvmCompile.getDestinationDirectory().get()).getAsFile());
            spec.setTargetCompatibility(((JvmTarget)((KotlinJvmCompilerOptions)kotlinJvmCompile.getCompilerOptions()).getJvmTarget().get()).getTarget());
            spec.setSourceCompatibility(((JvmTarget)((KotlinJvmCompilerOptions)kotlinJvmCompile.getCompilerOptions()).getJvmTarget().get()).getTarget());
        }
        spec.setCompileClasspath(AjcAction.getCompileClasspath(compile).collect(Collectors.toList()));
        spec.setWorkingDir(this.projectLayout.getProjectDirectory().getAsFile());
        spec.setTempDir(compile.getTemporaryDir());
        spec.setAspectJClasspath((FileCollection)this.getClasspath());
        spec.setAspectJCompileOptions(this.getOptions());
        spec.setAdditionalInpath((FileCollection)this.getAdditionalInpath());
        spec.setLauncher((JavaLauncher)this.launcher.getOrNull());
        return spec;
    }

    public static Stream<File> getCompileClasspath(Task task) {
        FileCollection classpath = null;
        if (task instanceof AbstractCompile) {
            classpath = ((AbstractCompile)task).getClasspath();
        } else if (task instanceof KotlinJvmCompile) {
            classpath = ((KotlinJvmCompile)task).getLibraries();
        }
        if (classpath != null) {
            return classpath.getFiles().stream().filter(File::exists);
        }
        throw new IllegalArgumentException();
    }

    private static URL toURL(File file) {
        return file.toURI().toURL();
    }

    @Generated
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Generated
    public Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Generated
    public AspectJCompileOptions getOptions() {
        return this.options;
    }

    @Generated
    public ConfigurableFileCollection getAdditionalInpath() {
        return this.additionalInpath;
    }

    @Generated
    public Property<JavaLauncher> getLauncher() {
        return this.launcher;
    }
}

