/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJCompileOptions;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompileSpec;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompiler;
import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

@CacheableTask
public abstract class AspectjCompile
extends AbstractCompile {
    @Nested
    private final CompileOptions options = (CompileOptions)this.getProject().getObjects().newInstance(CompileOptions.class, new Object[0]);
    @Nested
    private final AspectJCompileOptions ajcOptions = (AspectJCompileOptions)this.getProject().getObjects().newInstance(AspectJCompileOptions.class, new Object[0]);

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Classpath
    public abstract ConfigurableFileCollection getAspectjClasspath();

    @Nested
    @Optional
    public abstract Property<JavaLauncher> getLauncher();

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Optional
    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return super.getDestinationDirectory();
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @TaskAction
    protected void compile() {
        if (!this.getDestinationDirectory().isPresent() && !this.getAjcOptions().getOutjar().isPresent()) {
            throw new IllegalStateException("Neither destinationDirectory, nor outjar are set.");
        }
        if (this.getDestinationDirectory().isPresent()) {
            this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{this.getDestinationDirectory()}).setFollowSymlinks(false));
        }
        AspectJCompileSpec spec2 = this.createSpec();
        WorkResult result = this.getCompiler().execute(spec2);
        this.setDidWork(result.getDidWork());
    }

    private AspectJCompiler getCompiler() {
        return new AspectJCompiler(this.getExecOperations());
    }

    protected AspectJCompileSpec createSpec() {
        AspectJCompileSpec spec = new AspectJCompileSpec();
        spec.setSourceFiles((Iterable)this.getSource());
        if (this.getDestinationDirectory().isPresent()) {
            spec.setDestinationDir((File)this.getDestinationDirectory().getAsFile().get());
        }
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath(new ArrayList(this.getClasspath().getFiles()));
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setAspectJClasspath((FileCollection)this.getAspectjClasspath());
        spec.setAspectJCompileOptions(this.getAjcOptions());
        spec.setLauncher((JavaLauncher)this.getLauncher().getOrNull());
        return spec;
    }

    public void options(Action<CompileOptions> action) {
        action.execute((Object)this.getOptions());
    }

    public void ajcOptions(Action<AspectJCompileOptions> action) {
        action.execute((Object)this.getAjcOptions());
    }

    @Generated
    public CompileOptions getOptions() {
        return this.options;
    }

    @Generated
    public AspectJCompileOptions getAjcOptions() {
        return this.ajcOptions;
    }
}

