/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj.internal;

import io.freefair.gradle.plugins.aspectj.AjcForkOptions;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompileSpec;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public class AspectJCompiler
implements Compiler<AspectJCompileSpec> {
    private final ExecOperations execOperations;

    public WorkResult execute(AspectJCompileSpec spec) {
        ExecResult result = this.execOperations.javaexec(ajc -> this.configureJavaExec((JavaExecSpec)ajc, spec));
        if (result.getExitValue() != 0) {
            throw new CompilationFailedException(result.getExitValue());
        }
        return WorkResults.didWork((boolean)true);
    }

    private void configureJavaExec(JavaExecSpec ajc, AspectJCompileSpec spec) {
        List compileClasspath;
        if (spec.getLauncher() != null) {
            ajc.setExecutable(spec.getLauncher().getExecutablePath().getAsFile().getAbsolutePath());
        }
        ajc.setWorkingDir(spec.getWorkingDir());
        ajc.setClasspath(spec.getAspectJClasspath());
        ajc.getMainClass().set((Object)"org.aspectj.tools.ajc.Main");
        AjcForkOptions forkOptions = spec.getAspectJCompileOptions().getForkOptions();
        ajc.setMinHeapSize(forkOptions.getMemoryInitialSize());
        ajc.setMaxHeapSize(forkOptions.getMemoryMaximumSize());
        ajc.jvmArgs((Iterable)forkOptions.getJvmArgs());
        LinkedList<String> args = new LinkedList<String>();
        LinkedHashSet<File> inpath = new LinkedHashSet<File>();
        if (spec.getAdditionalInpath() != null && !spec.getAdditionalInpath().isEmpty()) {
            inpath.addAll(spec.getAdditionalInpath().getFiles());
        }
        if (!spec.getAspectJCompileOptions().getInpath().isEmpty()) {
            inpath.addAll(spec.getAspectJCompileOptions().getInpath().getFiles());
        }
        if (!inpath.isEmpty()) {
            args.add("-inpath");
            args.add(this.getAsPath(inpath));
        }
        if (!spec.getAspectJCompileOptions().getAspectpath().isEmpty()) {
            args.add("-aspectpath");
            args.add(this.getAsPath(spec.getAspectJCompileOptions().getAspectpath().getFiles()));
        }
        if (spec.getAspectJCompileOptions().getOutjar().isPresent()) {
            args.add("-outjar");
            args.add(((RegularFile)spec.getAspectJCompileOptions().getOutjar().get()).getAsFile().getAbsolutePath());
        }
        if (((Boolean)spec.getAspectJCompileOptions().getOutxml().getOrElse((Object)false)).booleanValue()) {
            args.add("-outxml");
        }
        if (spec.getAspectJCompileOptions().getOutxmlfile().isPresent()) {
            args.add("-outxmlfile");
            args.add((String)spec.getAspectJCompileOptions().getOutxmlfile().get());
        }
        if (!spec.getAspectJCompileOptions().getSourceroots().isEmpty()) {
            args.add("-sourceroots");
            args.add(spec.getAspectJCompileOptions().getSourceroots().getAsPath());
        }
        if (((Boolean)spec.getAspectJCompileOptions().getCrossrefs().getOrElse((Object)false)).booleanValue()) {
            args.add("-crossrefs");
        }
        if ((compileClasspath = spec.getCompileClasspath()) != null && !compileClasspath.isEmpty()) {
            args.add("-classpath");
            args.add(this.getAsPath(compileClasspath));
        }
        if (!spec.getAspectJCompileOptions().getBootclasspath().isEmpty()) {
            args.add("-bootclasspath");
            args.add(this.getAsPath(spec.getAspectJCompileOptions().getBootclasspath().getFiles()));
        }
        if (!spec.getAspectJCompileOptions().getExtdirs().isEmpty()) {
            args.add("-extdirs");
            args.add(this.getAsPath(spec.getAspectJCompileOptions().getExtdirs().getFiles()));
        }
        if (spec.getAspectJCompileOptions().getXmlConfigured().isPresent()) {
            args.add("-xmlConfigured");
            args.add(((RegularFile)spec.getAspectJCompileOptions().getXmlConfigured().get()).getAsFile().getAbsolutePath());
        }
        if (spec.getDestinationDir() != null) {
            args.add("-d");
            args.add(spec.getDestinationDir().getAbsolutePath());
        }
        if (spec.getTargetCompatibility() != null) {
            args.add("-target");
            args.add(spec.getTargetCompatibility());
        }
        if (spec.getSourceCompatibility() != null) {
            args.add("-source");
            args.add(spec.getSourceCompatibility());
        }
        if (spec.getAspectJCompileOptions().getEncoding().isPresent()) {
            args.add("-encoding");
            args.add((String)spec.getAspectJCompileOptions().getEncoding().get());
        }
        if (((Boolean)spec.getAspectJCompileOptions().getVerbose().getOrElse((Object)false)).booleanValue()) {
            args.add("-verbose");
        }
        args.addAll(spec.getAspectJCompileOptions().getCompilerArgs());
        spec.getAspectJCompileOptions().getCompilerArgumentProviders().forEach(commandLineArgumentProvider -> commandLineArgumentProvider.asArguments().forEach(args::add));
        if (spec.getSourceFiles() != null) {
            spec.getSourceFiles().forEach(sourceFile -> args.add(sourceFile.getAbsolutePath()));
        }
        File argFile = new File(spec.getTempDir(), "ajc.options");
        Files.write(argFile.toPath(), args, StandardCharsets.UTF_8, new OpenOption[0]);
        ajc.args(new Object[]{"-argfile", argFile.getAbsolutePath()});
        ajc.setIgnoreExitValue(true);
    }

    private String getAsPath(Collection<File> files) {
        return files.stream().filter(File::exists).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    @Generated
    public AspectJCompiler(ExecOperations execOperations) {
        this.execOperations = execOperations;
    }
}

