/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.sass;

import com.sass_lang.embedded_protocol.OutboundMessage;
import com.sass_lang.embedded_protocol.OutputStyle;
import de.larsgrefer.sass.embedded.CompileSuccess;
import de.larsgrefer.sass.embedded.SassCompilationFailedException;
import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.SassCompilerFactory;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import de.larsgrefer.sass.embedded.importer.CustomImporter;
import de.larsgrefer.sass.embedded.importer.FileImporter;
import de.larsgrefer.sass.embedded.importer.WebjarsImporter;
import de.larsgrefer.sass.embedded.logging.LoggingHandler;
import de.larsgrefer.sass.embedded.logging.Slf4jLoggingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.webjars.WebJarAssetLocator;

@CacheableTask
public abstract class SassCompile
extends SourceTask {
    @Input
    private final Property<OutputStyle> outputStyle = this.getProject().getObjects().property(OutputStyle.class);

    public SassCompile() {
        this.include(new String[]{"**/*.scss"});
        this.include(new String[]{"**/*.sass"});
        ExtraPropertiesExtension extraProperties = new DslObject((Object)this).getExtensions().getExtraProperties();
        for (OutputStyle value : OutputStyle.values()) {
            extraProperties.set(value.name(), (Object)value);
        }
    }

    @OutputDirectory
    public abstract DirectoryProperty getDestinationDir();

    @TaskAction
    public void compileSass() throws IOException {
        try (final SassCompiler compiler = SassCompilerFactory.bundled();){
            compiler.setOutputStyle((OutputStyle)this.getOutputStyle().getOrNull());
            compiler.setGenerateSourceMaps(((Boolean)this.getSourceMapEnabled().getOrElse((Object)true)).booleanValue());
            compiler.setSourceMapIncludeSources(((Boolean)this.getSourceMapContents().getOrElse((Object)false)).booleanValue());
            compiler.setLoggingHandler((LoggingHandler)new Slf4jLoggingHandler((Logger)this.getLogger()));
            compiler.getLoadPaths().addAll(this.getIncludePaths().getFiles());
            ((List)this.getFileImporters().get()).forEach(arg_0 -> ((SassCompiler)compiler).registerImporter(arg_0));
            ((List)this.getCustomImporters().get()).forEach(arg_0 -> ((SassCompiler)compiler).registerImporter(arg_0));
            ((List)this.getHostFunctions().get()).forEach(arg_0 -> ((SassCompiler)compiler).registerFunction(arg_0));
            if (!this.getWebjars().isEmpty()) {
                LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                for (File webjar : this.getWebjars()) {
                    urls.add(webjar.toURI().toURL());
                }
                URLClassLoader webjarsLoader = new URLClassLoader(urls.toArray(new URL[0]));
                compiler.registerImporter(new WebjarsImporter((ClassLoader)webjarsLoader, new WebJarAssetLocator((ClassLoader)webjarsLoader)).autoCanonicalize());
            }
            OutboundMessage.VersionResponse version = compiler.getVersion();
            this.getLogger().info("{}", (Object)version);
            this.getSource().visit((FileVisitor)new EmptyFileVisitor(){

                public void visitFile(@Nonnull FileVisitDetails fileVisitDetails) {
                    block9: {
                        String name = fileVisitDetails.getName();
                        if (name.startsWith("_")) {
                            return;
                        }
                        if (name.endsWith(".scss") || name.endsWith(".sass")) {
                            File in = fileVisitDetails.getFile();
                            String pathString = fileVisitDetails.getRelativePath().getPathString();
                            pathString = pathString.substring(0, pathString.length() - 5) + ".css";
                            File realOut = new File(((Directory)SassCompile.this.getDestinationDir().get()).getAsFile(), pathString);
                            File realMap = new File(((Directory)SassCompile.this.getDestinationDir().get()).getAsFile(), pathString + ".map");
                            try {
                                String css;
                                CompileSuccess output = compiler.compileFile(in, (OutputStyle)SassCompile.this.getOutputStyle().getOrElse((Object)compiler.getOutputStyle()));
                                if (realOut.getParentFile().exists() || realOut.getParentFile().mkdirs()) {
                                    css = output.getCss();
                                    if (((Boolean)SassCompile.this.getSourceMapEnabled().get()).booleanValue()) {
                                        String mapUrl = (Boolean)SassCompile.this.getSourceMapEmbed().get() != false ? "data:application/json;base64," + Base64.getEncoder().encodeToString(output.getSourceMapBytes().toByteArray()) : realMap.getName();
                                        css = css + "\n/*# sourceMappingURL=" + mapUrl + " */";
                                    }
                                } else {
                                    SassCompile.this.getLogger().error("Cannot write into {}", (Object)realOut.getParentFile());
                                    throw new GradleException("Cannot write into " + realMap.getParentFile());
                                }
                                Files.write(realOut.toPath(), css.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                                if (!((Boolean)SassCompile.this.getSourceMapEnabled().get()).booleanValue() || ((Boolean)SassCompile.this.getSourceMapEmbed().get()).booleanValue()) break block9;
                                if (realMap.getParentFile().exists() || realMap.getParentFile().mkdirs()) {
                                    Files.write(realMap.toPath(), output.getSourceMap().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                                    break block9;
                                }
                                SassCompile.this.getLogger().error("Cannot write into {}", (Object)realMap.getParentFile());
                                throw new GradleException("Cannot write into " + realMap.getParentFile());
                            }
                            catch (SassCompilationFailedException e) {
                                OutboundMessage.CompileResponse.CompileFailure sassError = e.getCompileFailure();
                                SassCompile.this.getLogger().error(sassError.getMessage());
                                throw new RuntimeException(e);
                            }
                            catch (IOException e) {
                                SassCompile.this.getLogger().error(e.getLocalizedMessage());
                                throw new UncheckedIOException((Throwable)e);
                            }
                        }
                    }
                }
            });
        }
    }

    @Input
    @Optional
    public abstract ListProperty<HostFunction> getHostFunctions();

    @Input
    @Optional
    public abstract ListProperty<FileImporter> getFileImporters();

    @Input
    @Optional
    public abstract ListProperty<CustomImporter> getCustomImporters();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getWebjars();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getIncludePaths();

    @Input
    public abstract Property<Boolean> getOmitSourceMapUrl();

    @Input
    public abstract Property<Boolean> getSourceMapContents();

    @Input
    public abstract Property<Boolean> getSourceMapEmbed();

    @Input
    public abstract Property<Boolean> getSourceMapEnabled();

    @Input
    @Optional
    public abstract Property<URI> getSourceMapRoot();

    public void setOutputStyle(String outputStyle) {
        this.getOutputStyle().set((Object)OutputStyle.valueOf((String)outputStyle.trim().toUpperCase()));
    }

    @Generated
    public Property<OutputStyle> getOutputStyle() {
        return this.outputStyle;
    }
}

