/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.sass;

import io.freefair.gradle.plugins.sass.SassCompile;
import io.freefair.gradle.plugins.sass.SassWebjarsPlugin;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;

@Incubating
public class SassWarPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(SassWebjarsPlugin.class);
        project.getPlugins().apply(WarPlugin.class);
        TaskProvider warTask = project.getTasks().named("war", War.class);
        TaskProvider sassCompileTaskProvider = project.getTasks().register("compileWebappSass", SassCompile.class, compileWebappSass -> {
            compileWebappSass.setGroup("build");
            compileWebappSass.setDescription("Compile sass and scss files for the webapp");
            compileWebappSass.source(new Object[]{warTask.flatMap(War::getWebAppDirectory)});
            compileWebappSass.getDestinationDir().set(project.getLayout().getBuildDirectory().dir("sass/webapp"));
        });
        warTask.configure(war -> war.from(new Object[]{sassCompileTaskProvider}));
    }
}

