/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.git;

import io.freefair.gradle.util.GitUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class GitVersionPlugin
implements Plugin<Project> {
    private static final Pattern releaseBranchPattern = Pattern.compile("release-(\\d+.*)");
    private static final Pattern hotfixBranchPattern = Pattern.compile("hotfix-(\\d+.*)");
    private static final Pattern vTagPattern = Pattern.compile("v(\\d+.*)");
    private Project project;
    private Logger logger;

    public void apply(Project project) {
        this.project = project;
        this.logger = project.getLogger();
        project.setVersion(this.resolveVersion());
        project.allprojects(p -> p.setVersion(project.getVersion()));
    }

    protected String resolveBranchVersion(String branch) {
        String baseVersion = branch;
        Matcher matcher = releaseBranchPattern.matcher(branch);
        if (matcher.matches()) {
            baseVersion = matcher.group(1);
        }
        if ((matcher = hotfixBranchPattern.matcher(branch)).matches()) {
            baseVersion = matcher.group(1);
        }
        baseVersion = baseVersion.replace("/", "-");
        return baseVersion + "-SNAPSHOT";
    }

    protected String resolveTagVersion(String tag) {
        String version = tag;
        Matcher matcher = vTagPattern.matcher(tag);
        if (matcher.matches()) {
            version = matcher.group(1);
        }
        return version;
    }

    private Object resolveVersion() {
        String gitBranch;
        Process execute;
        if (!"unspecified".equals(this.project.getVersion().toString())) {
            this.logger.lifecycle("Using explicit version {}", new Object[]{this.project.getVersion()});
            return this.project.getVersion();
        }
        if (GitUtil.isTravisCi()) {
            String travisTag = System.getenv("TRAVIS_TAG");
            if (travisTag != null && !travisTag.trim().isEmpty()) {
                String version = this.resolveTagVersion(travisTag);
                this.logger.lifecycle("Using TRAVIS_TAG '{}' as version: {}", new Object[]{travisTag, version});
                return version;
            }
            String travisBranch = System.getenv("TRAVIS_BRANCH");
            if (travisBranch != null) {
                String version = this.resolveBranchVersion(travisBranch);
                this.logger.lifecycle("Using TRAVIS_BRANCH '{}' as version: {}", new Object[]{travisBranch, version});
                return version;
            }
        } else if (GitUtil.isGithubActions()) {
            String githubRef = System.getenv("GITHUB_REF");
            if (githubRef != null) {
                if (githubRef.startsWith("refs/tags/")) {
                    githubRef = githubRef.substring("refs/tags/".length());
                    String version = this.resolveTagVersion(githubRef);
                    this.logger.lifecycle("Using GitHub Tag '{}' as version: {}", new Object[]{githubRef, version});
                    return version;
                }
                if (githubRef.startsWith("refs/heads/")) {
                    githubRef = githubRef.substring("refs/heads/".length());
                    String version = this.resolveBranchVersion(githubRef);
                    this.logger.lifecycle("Using GitHub Branch '{}' as version: {}", new Object[]{githubRef, version});
                    return version;
                }
            }
        } else if (GitUtil.isCircleCi()) {
            String circleTag = System.getenv("CIRCLE_TAG");
            if (circleTag != null && !circleTag.trim().isEmpty()) {
                String version = this.resolveTagVersion(circleTag);
                this.logger.lifecycle("Using CIRCLE_TAG '{}' as version: {}", new Object[]{circleTag, version});
                return version;
            }
            String circleBranch = System.getenv("CIRCLE_BRANCH");
            if (circleBranch != null) {
                String version = this.resolveBranchVersion(circleBranch);
                this.logger.lifecycle("Using CIRCLE_BRANCH '{}' as version: {}", new Object[]{circleBranch, version});
                return version;
            }
        }
        try {
            execute = ProcessGroovyMethods.execute((String)"git describe --tags --exact-match");
            String gitTag = ProcessGroovyMethods.getText((Process)execute).trim();
            if (!gitTag.isEmpty()) {
                String version = this.resolveTagVersion(gitTag);
                this.logger.lifecycle("Using git tag '{}' as version: {}", new Object[]{gitTag, version});
                return gitTag;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to get current git tag", (Throwable)e);
        }
        if (GitUtil.isJenkins()) {
            String gitLocalBranch = System.getenv("GIT_LOCAL_BRANCH");
            if (gitLocalBranch != null && !gitLocalBranch.isEmpty()) {
                String version = this.resolveBranchVersion(gitLocalBranch);
                this.logger.lifecycle("Using GIT_LOCAL_BRANCH '{}' as version: {}", new Object[]{gitLocalBranch, version});
                return version;
            }
            gitBranch = System.getenv("GIT_BRANCH");
            if (gitBranch != null && !gitBranch.isEmpty()) {
                String version = this.resolveBranchVersion(gitBranch);
                this.logger.lifecycle("Using GIT_BRANCH '{}' as version: {}", new Object[]{gitBranch, version});
                return version;
            }
            String branchName = System.getenv("BRANCH_NAME");
            if (branchName != null && !branchName.isEmpty()) {
                String version = this.resolveBranchVersion(branchName);
                this.logger.lifecycle("Using BRANCH_NAME '{}' as version: {}", new Object[]{branchName, version});
                return version;
            }
        }
        try {
            execute = ProcessGroovyMethods.execute((String)"git symbolic-ref --short HEAD");
            gitBranch = ProcessGroovyMethods.getText((Process)execute).trim();
            if (!gitBranch.isEmpty()) {
                String version = this.resolveBranchVersion(gitBranch);
                this.logger.lifecycle("Using git branch '{}' as version: {}", new Object[]{gitBranch, version});
                return version;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to get current git branch", (Throwable)e);
        }
        return this.project.getVersion();
    }
}

