/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.git;

import io.freefair.gradle.util.GitUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public class GitVersionPlugin
implements Plugin<Project> {
    private static final Pattern releaseBranchPattern = Pattern.compile("release-(\\d+.*)");
    private static final Pattern hotfixBranchPattern = Pattern.compile("hotfix-(\\d+.*)");
    private static final Pattern vTagPattern = Pattern.compile("v(\\d+.*)");
    private Project project;
    private Logger logger;

    public void apply(Project project) {
        this.project = project;
        this.logger = project.getLogger();
        project.setVersion(this.resolveVersion());
        project.allprojects(p -> p.setVersion(project.getVersion()));
    }

    protected String resolveBranchVersion(String branch) {
        String baseVersion = branch;
        Matcher matcher = releaseBranchPattern.matcher(branch);
        if (matcher.matches()) {
            baseVersion = matcher.group(1);
        }
        if ((matcher = hotfixBranchPattern.matcher(branch)).matches()) {
            baseVersion = matcher.group(1);
        }
        baseVersion = baseVersion.replace("/", "-");
        return baseVersion + "-SNAPSHOT";
    }

    protected String resolveTagVersion(String tag) {
        String version = tag;
        Matcher matcher = vTagPattern.matcher(tag);
        if (matcher.matches()) {
            version = matcher.group(1);
        }
        return version;
    }

    private Object resolveVersion() {
        String version;
        if (!"unspecified".equals(this.project.getVersion().toString())) {
            this.logger.lifecycle("Using explicit version {}", new Object[]{this.project.getVersion()});
            return this.project.getVersion();
        }
        ProviderFactory providerFactory = this.project.getProviders();
        if (GitUtil.isTravisCi((ProviderFactory)providerFactory)) {
            Provider travisTag = providerFactory.environmentVariable("TRAVIS_TAG");
            if (travisTag.isPresent()) {
                String version2 = this.resolveTagVersion(((String)travisTag.get()).trim());
                this.logger.lifecycle("Using TRAVIS_TAG '{}' as version: {}", new Object[]{travisTag, version2});
                return version2;
            }
            Provider travisBranch = providerFactory.environmentVariable("TRAVIS_BRANCH");
            if (travisBranch.isPresent()) {
                String version3 = this.resolveBranchVersion((String)travisBranch.get());
                this.logger.lifecycle("Using TRAVIS_BRANCH '{}' as version: {}", new Object[]{travisBranch, version3});
                return version3;
            }
        } else if (GitUtil.isGithubActions((ProviderFactory)providerFactory)) {
            Provider githubRef = providerFactory.environmentVariable("GITHUB_REF");
            if (githubRef.isPresent()) {
                if (((String)githubRef.get()).startsWith("refs/tags/")) {
                    String tag = ((String)githubRef.get()).substring("refs/tags/".length());
                    String version4 = this.resolveTagVersion(tag);
                    this.logger.lifecycle("Using GitHub Tag '{}' as version: {}", new Object[]{githubRef, version4});
                    return version4;
                }
                if (((String)githubRef.get()).startsWith("refs/heads/")) {
                    String branch = ((String)githubRef.get()).substring("refs/heads/".length());
                    String version5 = this.resolveBranchVersion(branch);
                    this.logger.lifecycle("Using GitHub Branch '{}' as version: {}", new Object[]{githubRef, version5});
                    return version5;
                }
                this.logger.warn("Unknown prefix for 'GITHUB_REF' {}", githubRef.get());
            } else {
                this.logger.warn("No GITHUB_REF found on GitHub Actions");
            }
        } else if (GitUtil.isCircleCi((ProviderFactory)providerFactory)) {
            Provider circleTag = providerFactory.environmentVariable("CIRCLE_TAG");
            if (circleTag.isPresent()) {
                String version6 = this.resolveTagVersion(((String)circleTag.get()).trim());
                this.logger.lifecycle("Using CIRCLE_TAG '{}' as version: {}", new Object[]{circleTag, version6});
                return version6;
            }
            Provider circleBranch = providerFactory.environmentVariable("CIRCLE_BRANCH");
            if (circleBranch.isPresent()) {
                String version7 = this.resolveBranchVersion((String)circleBranch.get());
                this.logger.lifecycle("Using CIRCLE_BRANCH '{}' as version: {}", new Object[]{circleBranch, version7});
                return version7;
            }
        } else if (GitUtil.isGitLab((ProviderFactory)providerFactory)) {
            Provider gitLabTag = providerFactory.environmentVariable("CI_COMMIT_TAG");
            if (gitLabTag.isPresent()) {
                String version8 = this.resolveTagVersion(((String)gitLabTag.get()).trim());
                this.logger.lifecycle("Using CI_COMMIT_TAG '{}' as version: {}", new Object[]{gitLabTag, version8});
                return version8;
            }
            Provider gitLabBranch = providerFactory.environmentVariable("CI_COMMIT_BRANCH");
            if (gitLabBranch.isPresent()) {
                String version9 = this.resolveBranchVersion((String)gitLabBranch.get());
                this.logger.lifecycle("Using CI_COMMIT_BRANCH '{}' as version: {}", new Object[]{gitLabBranch, version9});
                return version9;
            }
        }
        try {
            String gitTag = ((String)providerFactory.exec(execSpec -> {
                execSpec.setWorkingDir(this.project.getProjectDir());
                execSpec.commandLine(new Object[]{"git", "describe", "--tags", "--exact-match", "--dirty=-SNAPSHOT"});
                execSpec.setIgnoreExitValue(true);
            }).getStandardOutput().getAsText().get()).trim();
            if (!gitTag.isEmpty()) {
                version = this.resolveTagVersion(gitTag);
                this.logger.lifecycle("Using git tag '{}' as version: {}", new Object[]{gitTag, version});
                return gitTag;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to get current git tag", (Throwable)e);
        }
        if (GitUtil.isJenkins((ProviderFactory)providerFactory)) {
            Provider gitLocalBranch = providerFactory.environmentVariable("GIT_LOCAL_BRANCH");
            if (gitLocalBranch.isPresent()) {
                version = this.resolveBranchVersion((String)gitLocalBranch.get());
                this.logger.lifecycle("Using GIT_LOCAL_BRANCH '{}' as version: {}", new Object[]{gitLocalBranch, version});
                return version;
            }
            Provider gitBranch = providerFactory.environmentVariable("GIT_BRANCH");
            if (gitBranch.isPresent()) {
                String version10 = this.resolveBranchVersion((String)gitBranch.get());
                this.logger.lifecycle("Using GIT_BRANCH '{}' as version: {}", new Object[]{gitBranch, version10});
                return version10;
            }
            Provider branchName = providerFactory.environmentVariable("BRANCH_NAME");
            if (branchName.isPresent()) {
                String version11 = this.resolveBranchVersion((String)branchName.get());
                this.logger.lifecycle("Using BRANCH_NAME '{}' as version: {}", new Object[]{branchName, version11});
                return version11;
            }
        }
        try {
            String gitBranch = ((String)providerFactory.exec(execSpec -> {
                execSpec.setWorkingDir(this.project.getProjectDir());
                execSpec.commandLine(new Object[]{"git", "symbolic-ref", "--short", "HEAD"});
            }).getStandardOutput().getAsText().get()).trim();
            if (!gitBranch.isEmpty()) {
                version = this.resolveBranchVersion(gitBranch);
                this.logger.lifecycle("Using git branch '{}' as version: {}", new Object[]{gitBranch, version});
                return version;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to get current git branch", (Throwable)e);
        }
        this.logger.warn("Failed to infer the project version from git. Keeping {}", this.project.getVersion());
        return this.project.getVersion();
    }
}

