/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github;

import io.freefair.gradle.plugins.github.GithubExtension;
import io.freefair.gradle.plugins.github.GithubPomPlugin;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;

public class GithubPackageRegistryMavenPublishPlugin
implements Plugin<Project> {
    private GithubExtension githubExtension;
    private MavenArtifactRepository githubRepository;

    public void apply(Project project) {
        project.getPlugins().apply(MavenPublishPlugin.class);
        project.getPlugins().apply(GithubPomPlugin.class);
        this.githubExtension = (GithubExtension)project.getRootProject().getExtensions().getByType(GithubExtension.class);
        project.afterEvaluate(this::registerGitHubPackagesRepository);
    }

    private void registerGitHubPackagesRepository(Project project) {
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        this.githubRepository = publishing.getRepositories().maven(githubRepo -> {
            githubRepo.setName("GitHubPackages");
            githubRepo.setUrl((Object)("https://maven.pkg.github.com/" + (String)this.githubExtension.getSlug().get()));
            if (this.githubExtension.getUsername().isPresent() && this.githubExtension.getToken().isPresent()) {
                githubRepo.credentials(passwordCredentials -> {
                    passwordCredentials.setUsername((String)this.githubExtension.getUsername().get());
                    passwordCredentials.setPassword((String)this.githubExtension.getToken().get());
                });
            }
        });
    }

    @Generated
    public MavenArtifactRepository getGithubRepository() {
        return this.githubRepository;
    }
}

