/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github;

import io.freefair.gradle.plugins.github.GithubBasePlugin;
import io.freefair.gradle.plugins.github.GithubExtension;
import io.freefair.gradle.plugins.github.internal.GithubService;
import io.freefair.gradle.plugins.github.internal.License;
import io.freefair.gradle.plugins.github.internal.Repo;
import io.freefair.gradle.plugins.github.internal.User;
import io.freefair.gradle.util.GitUtil;
import java.io.IOException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.plugins.PublishingPlugin;

public class GithubPomPlugin
implements Plugin<Project> {
    private GithubExtension githubExtension;
    private Project project;
    private GithubBasePlugin githubBasePlugin;
    private GithubService githubService;
    private String slug;
    private Repo repo;
    private User user;
    private License ghLicense;

    public void apply(Project project) {
        this.project = project;
        this.githubBasePlugin = (GithubBasePlugin)project.getRootProject().getPlugins().apply(GithubBasePlugin.class);
        this.githubExtension = this.githubBasePlugin.getGithubExtension();
        this.githubService = this.githubBasePlugin.getGithubClient().getGithubService();
        project.afterEvaluate(p -> {
            this.slug = (String)this.githubExtension.getSlug().get();
            try {
                this.repo = (Repo)this.githubService.getRepository(this.slug).execute().body();
                this.user = (User)this.githubService.getUser((String)this.githubExtension.getOwner().get()).execute().body();
                if (this.repo.getLicense() != null) {
                    this.ghLicense = (License)this.githubService.getLicense(this.repo.getLicense().getUrl()).execute().body();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            project.getPlugins().withType(PublishingPlugin.class, publishingPlugin -> ((PublishingExtension)project.getExtensions().getByType(PublishingExtension.class)).getPublications().withType(MavenPublication.class, this::configureMavenPublication));
        });
    }

    private void configureMavenPublication(MavenPublication mavenPublication) {
        mavenPublication.pom(pom -> {
            if (this.hasText(this.repo.getHomepage())) {
                pom.getUrl().convention((Object)this.repo.getHomepage());
            } else {
                pom.getUrl().convention((Object)this.repo.getHtml_url());
            }
            if (this.hasText(this.repo.getDescription())) {
                pom.getDescription().convention((Object)this.repo.getDescription());
            } else {
                pom.getDescription().convention((Object)this.project.getDescription());
            }
            pom.getName().convention((Object)this.project.getName());
            pom.getInceptionYear().convention((Object)this.repo.getCreated_at().substring(0, 4));
            pom.organization(organization -> {
                if (this.hasText(this.user.getName())) {
                    organization.getName().convention((Object)this.user.getName());
                } else {
                    organization.getName().convention((Object)this.user.getLogin());
                }
                if (this.hasText(this.user.getBlog())) {
                    organization.getUrl().convention((Object)this.user.getBlog());
                } else {
                    organization.getUrl().convention((Object)this.user.getHtml_url());
                }
            });
            if (((Boolean)this.githubExtension.getTravis().getOrElse((Object)false)).booleanValue()) {
                pom.ciManagement(ciManagement -> {
                    ciManagement.getSystem().convention((Object)"Travis CI");
                    ciManagement.getUrl().convention((Object)String.format("https://travis-ci.org/%s/", this.slug));
                });
            } else if (GitUtil.isGithubActions()) {
                pom.ciManagement(ciManagement -> {
                    ciManagement.getSystem().convention((Object)"GitHub Actions");
                    ciManagement.getUrl().convention((Object)String.format("https://github.com/%s/actions", this.slug));
                });
            }
            if (this.repo.isHas_issues()) {
                pom.issueManagement(issueManagement -> {
                    issueManagement.getSystem().convention((Object)"GitHub Issues");
                    issueManagement.getUrl().convention((Object)String.format("https://github.com/%s/issues", this.slug));
                });
            }
            if (this.ghLicense != null && ((MavenPomInternal)pom).getLicenses().isEmpty()) {
                pom.licenses(licences -> licences.license(licence -> {
                    licence.getName().convention((Object)this.ghLicense.getName());
                    licence.getUrl().convention((Object)this.ghLicense.getHtml_url());
                    licence.getComments().convention((Object)this.ghLicense.getDescription());
                }));
            }
            pom.scm(scm -> {
                scm.getUrl().convention((Object)this.repo.getHtml_url());
                scm.getConnection().convention((Object)("scm:git:" + this.repo.getClone_url()));
                scm.getDeveloperConnection().convention((Object)("scm:git:" + this.repo.getSsh_url()));
                scm.getTag().convention(this.githubExtension.getTag());
            });
        });
    }

    private boolean hasText(String text) {
        return text != null && !text.isEmpty();
    }
}

