/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class GithubExtension {
    private static final Pattern slugPattern = Pattern.compile("(.*)/(.*)");
    private final Property<String> slug;
    private final Property<String> username;
    private final Property<String> token;
    private final Property<String> tag;
    private final Property<Boolean> travis;

    @Inject
    public GithubExtension(ObjectFactory objectFactory) {
        this.slug = objectFactory.property(String.class);
        this.username = objectFactory.property(String.class);
        this.token = objectFactory.property(String.class);
        this.tag = objectFactory.property(String.class).convention((Object)"HEAD");
        this.travis = objectFactory.property(Boolean.class).convention((Object)false);
    }

    public Provider<String> getOwner() {
        return this.slug.map(sl -> {
            Matcher matcher = slugPattern.matcher((CharSequence)sl);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return "";
        });
    }

    public void setOwner(String owner) {
        this.slug.set((Object)(owner + "/" + (String)this.getRepo().getOrElse((Object)"")));
    }

    public Provider<String> getRepo() {
        return this.slug.map(sl -> {
            Matcher matcher = slugPattern.matcher((CharSequence)sl);
            if (matcher.matches()) {
                return matcher.group(2);
            }
            return "";
        });
    }

    public void setRepo(String repo) {
        this.slug.set((Object)((String)this.getOwner().getOrElse((Object)"") + "/" + repo));
    }

    @Generated
    public Property<String> getSlug() {
        return this.slug;
    }

    @Generated
    public Property<String> getUsername() {
        return this.username;
    }

    @Generated
    public Property<String> getToken() {
        return this.token;
    }

    @Generated
    public Property<String> getTag() {
        return this.tag;
    }

    @Generated
    public Property<Boolean> getTravis() {
        return this.travis;
    }
}

