/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github.internal;

import io.freefair.gradle.plugins.github.GithubExtension;
import io.freefair.gradle.plugins.github.internal.GithubService;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.gradle.api.NonNullApi;
import org.gradle.api.provider.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@NonNullApi
public class GithubClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GithubClient.class);
    private Retrofit retrofit;

    public GithubClient(GithubExtension githubExtension, OkHttpClient okHttpClient) {
        OkHttpClient client = okHttpClient.newBuilder().addInterceptor(chain -> {
            Request request = chain.request();
            Property<String> username = githubExtension.getUsername();
            Property<String> token = githubExtension.getToken();
            if (username.isPresent() && token.isPresent()) {
                request = request.newBuilder().header("Authorization", Credentials.basic((String)((String)username.get()), (String)((String)token.get()))).build();
            } else if (token.isPresent()) {
                request = request.newBuilder().header("Authorization", "Bearer " + (String)token.get()).build();
            }
            return chain.proceed(request);
        }).addInterceptor(this::logRateLimit).build();
        this.retrofit = new Retrofit.Builder().baseUrl("https://api.github.com/").client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
    }

    private Response logRateLimit(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        String limitString = response.header("X-RateLimit-Limit");
        String remainingString = response.header("X-RateLimit-Remaining");
        if (limitString != null && remainingString != null) {
            int limit = Integer.parseInt(limitString);
            int remaining = Integer.parseInt(remainingString);
            double d = (double)remaining / (double)limit;
            if (d < 0.1) {
                log.warn("{}/{} GitHub requests remaining", (Object)remainingString, (Object)limitString);
            } else {
                log.info("{}/{} GitHub requests remaining", (Object)remainingString, (Object)limitString);
            }
        }
        return response;
    }

    public GithubService getGithubService() {
        return (GithubService)this.retrofit.create(GithubService.class);
    }
}

