/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github.dependencies;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.freefair.gradle.plugins.github.internal.Detector;
import io.freefair.gradle.plugins.github.internal.Job;
import io.freefair.gradle.plugins.github.internal.Manifest;
import io.freefair.gradle.plugins.github.internal.Snapshot;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

@Deprecated
public abstract class DependencySnapshotTask
extends SourceTask {
    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract Property<String> getSha();

    @Input
    public abstract Property<String> getRef();

    @Input
    @Optional
    public abstract Property<String> getJobId();

    @Input
    public abstract Property<String> getJobCorrelator();

    @Input
    @Optional
    public abstract Property<String> getJobHtmlUrl();

    @PathSensitive(value=PathSensitivity.NONE)
    public FileTree getSource() {
        return super.getSource();
    }

    @TaskAction
    public void buildSnapshot() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Snapshot snapshot = new Snapshot();
        snapshot.setSha((String)this.getSha().get());
        snapshot.setRef((String)this.getRef().get());
        snapshot.setDetector(new Detector());
        snapshot.setManifests(new LinkedHashMap<String, Manifest>());
        snapshot.setScanned(Instant.now().truncatedTo(ChronoUnit.SECONDS).toString());
        snapshot.setJob(new Job());
        snapshot.getJob().setId((String)this.getJobId().getOrElse((Object)UUID.randomUUID().toString()));
        snapshot.getJob().setCorrelator((String)this.getJobCorrelator().get());
        snapshot.getJob().setHtml_url((String)this.getJobHtmlUrl().getOrNull());
        for (File file : this.getSource()) {
            FileReader fileReader = new FileReader(file);
            Throwable throwable = null;
            try {
                Manifest manifest = (Manifest)gson.fromJson((Reader)fileReader, Manifest.class);
                snapshot.getManifests().put(manifest.getName(), manifest);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileReader == null) continue;
                if (throwable != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileReader.close();
            }
        }
        String json = gson.toJson((Object)snapshot);
        Files.write(((File)this.getOutputFile().getAsFile().get()).toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

