/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github.internal;

import io.freefair.gradle.util.GitUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.process.ExecOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitUtils.class);
    private static final Pattern httpsUrlPattern = Pattern.compile("https://github\\.com/(.+/.+)\\.git");
    private static final Pattern sshUrlPattern = Pattern.compile("git@github.com:(.+/.+)\\.git");

    @Nullable
    public static String findSlug(Project project) {
        if (GitUtil.isGithubActions((ProviderFactory)project.getProviders())) {
            return (String)project.getProviders().environmentVariable("GITHUB_REPOSITORY").get();
        }
        String travisSlug = (String)GitUtils.findTravisSlug(project).getOrNull();
        if (travisSlug != null && !travisSlug.isEmpty()) {
            return travisSlug;
        }
        String remoteUrl = GitUtils.getRemoteUrl(project, "origin");
        Matcher httpsMatcher = httpsUrlPattern.matcher(remoteUrl);
        if (httpsMatcher.matches()) {
            return httpsMatcher.group(1);
        }
        Matcher sshMatcher = sshUrlPattern.matcher(remoteUrl);
        if (sshMatcher.matches()) {
            return sshMatcher.group(1);
        }
        return null;
    }

    @Nonnull
    public static Provider<String> findTravisSlug(Project project) {
        Provider travisRepoSlug = project.getProviders().environmentVariable("TRAVIS_REPO_SLUG");
        ExecOutput execOutput = project.getProviders().exec(execSpec -> {
            execSpec.workingDir((Object)project.getProjectDir());
            execSpec.commandLine(new Object[]{"git", "config", "travis.slug"});
            execSpec.setIgnoreExitValue(true);
        });
        return travisRepoSlug.orElse(execOutput.getStandardOutput().getAsText().map(String::trim));
    }

    public static String getRemoteUrl(Project project, String remote) {
        return (String)GitUtil.execute((Project)project, (String[])new String[]{"git", "ls-remote", "--get-url", remote}).get();
    }

    public static Provider<File> findWorkingDirectory(Project project) {
        Provider gitToplevel = GitUtil.execute((Project)project, (String[])new String[]{"git", "rev-parse", "--show-toplevel"});
        return project.getProviders().environmentVariable("TRAVIS_BUILD_DIR").orElse(project.getProviders().environmentVariable("GITHUB_WORKSPACE")).orElse(gitToplevel).map(File::new);
    }

    public static Provider<String> getTag(Project project) {
        Provider travisTag = project.getProviders().environmentVariable("TRAVIS_TAG");
        Provider githubTag = project.getProviders().environmentVariable("GITHUB_REF").map(githubRef -> {
            if (githubRef.startsWith("refs/tags/")) {
                return githubRef.substring("refs/tags/".length());
            }
            return null;
        });
        Provider gitlabTag = project.getProviders().environmentVariable("CI_COMMIT_TAG");
        return travisTag.orElse(githubTag).orElse(gitlabTag).orElse(GitUtil.execute((Project)project, (String[])new String[]{"git", "tag", "--points-at", "HEAD"})).orElse((Object)"HEAD");
    }

    @Nonnull
    public static Provider<String> findGithubUsername(Project project) {
        return project.getProviders().environmentVariable("GITHUB_ACTOR").orElse(project.getProviders().gradleProperty("githubUsername"));
    }

    @Nonnull
    public static Provider<String> findGithubToken(Project project) {
        return project.getProviders().environmentVariable("GITHUB_TOKEN").orElse(project.getProviders().gradleProperty("githubToken"));
    }

    @Generated
    private GitUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

