/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github.dependencies;

import io.freefair.gradle.plugins.github.dependencies.DependencyManifestTask;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.tasks.TaskProvider;

public class DependencyManifestPlugin
implements Plugin<Project> {
    private TaskProvider<DependencyManifestTask> manifestTaskProvider;

    public void apply(Project project) {
        this.manifestTaskProvider = project.getTasks().register("githubDependenciesManifest", DependencyManifestTask.class, dependencyManifestTask -> {
            dependencyManifestTask.setGroup("github");
            dependencyManifestTask.getOutputFile().set(project.getLayout().getBuildDirectory().file("github/dependency-manifest.json"));
            dependencyManifestTask.configureDefaults(project);
            Configuration classpath = project.getBuildscript().getConfigurations().getByName("classpath");
            dependencyManifestTask.getDevelopmentClasspaths().add(classpath.getIncoming().getResolutionResult().getRootComponent());
        });
        Configuration configuration = (Configuration)project.getConfigurations().create("githubDependenciesManifest");
        configuration.setCanBeResolved(false);
        configuration.setCanBeConsumed(true);
        configuration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)project.getObjects().named(Category.class, "verification"));
        configuration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)project.getObjects().named(Bundling.class, "external"));
        configuration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "github-dependency-manifest"));
        configuration.getOutgoing().artifact(this.manifestTaskProvider);
        project.getPlugins().withId("java", java -> this.manifestTaskProvider.configure(dependencyManifestTask -> {
            Configuration compileClasspath = project.getConfigurations().getByName("compileClasspath");
            dependencyManifestTask.getDevelopmentClasspaths().add(compileClasspath.getIncoming().getResolutionResult().getRootComponent());
            Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
            dependencyManifestTask.getRuntimeClasspaths().add(runtimeClasspath.getIncoming().getResolutionResult().getRootComponent());
        }));
    }

    @Generated
    public TaskProvider<DependencyManifestTask> getManifestTaskProvider() {
        return this.manifestTaskProvider;
    }
}

