/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github.dependencies;

import io.freefair.gradle.plugins.github.GithubBasePlugin;
import io.freefair.gradle.plugins.github.dependencies.DependencyManifestPlugin;
import io.freefair.gradle.plugins.github.dependencies.DependencySnapshotTask;
import io.freefair.gradle.plugins.github.dependencies.UploadSnapshotTask;
import io.freefair.gradle.util.GitUtil;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;

public class DependencySubmissionPlugin
implements Plugin<Project> {
    private TaskProvider<DependencySnapshotTask> githubDependencySnapshot;

    public void apply(Project project) {
        GithubBasePlugin basePlugin = (GithubBasePlugin)project.getPlugins().apply(GithubBasePlugin.class);
        this.githubDependencySnapshot = project.getTasks().register("githubDependencySnapshot", DependencySnapshotTask.class, gds -> {
            gds.getSha().convention(project.provider(() -> GitUtil.getSha((Project)project)));
            gds.getRef().convention(project.provider(() -> GitUtil.getRef((Project)project)));
            gds.getOutputFile().convention(project.getLayout().getBuildDirectory().file("github/dependency-snapshot.json"));
            gds.getJobCorrelator().convention((Object)project.getName());
            if (GitUtil.isGithubActions()) {
                gds.getJobId().set((Object)System.getenv("GITHUB_RUN_ID"));
                gds.getJobCorrelator().set((Object)String.format("%s_%s_%s", System.getenv("GITHUB_WORKFLOW"), System.getenv("GITHUB_JOB"), project.getName()));
                String htmlUrl = String.format("%s/%s/actions/runs/%s", System.getenv("GITHUB_SERVER_URL"), System.getenv("GITHUB_REPOSITORY"), System.getenv("GITHUB_RUN_ID"));
                gds.getJobHtmlUrl().set((Object)htmlUrl);
            } else if (GitUtil.isTravisCi()) {
                gds.getJobId().set((Object)System.getenv("TRAVIS_JOB_ID"));
                gds.getJobCorrelator().set((Object)String.format("%s_%s", System.getenv("TRAVIS_JOB_NAME"), project.getName()));
                gds.getJobHtmlUrl().set((Object)System.getenv("TRAVIS_JOB_WEB_URL"));
            } else if (GitUtil.isCircleCi()) {
                gds.getJobId().set((Object)System.getenv("CIRCLE_WORKFLOW_JOB_ID"));
                gds.getJobCorrelator().set((Object)String.format("%s_%s", System.getenv("CIRCLE_JOB"), project.getName()));
                gds.getJobCorrelator().set((Object)String.format("%s_%s", System.getenv("CIRCLE_BUILD_URL"), project.getName()));
            }
        });
        project.allprojects(this::configureProject);
        TaskProvider uploadGithubDependenciesSnapshot = project.getTasks().register("uploadGithubDependenciesSnapshot", UploadSnapshotTask.class, new Object[]{basePlugin.getGithubClient()});
        uploadGithubDependenciesSnapshot.configure(t -> {
            t.getSnapshotFile().set(this.githubDependencySnapshot.flatMap(DependencySnapshotTask::getOutputFile));
            t.getOwner().convention(basePlugin.getGithubExtension().getOwner());
            t.getRepo().convention(basePlugin.getGithubExtension().getRepo());
        });
    }

    private void configureProject(Project project) {
        DependencyManifestPlugin manifestPlugin = (DependencyManifestPlugin)project.getPlugins().apply(DependencyManifestPlugin.class);
        this.githubDependencySnapshot.configure(gds -> gds.source(new Object[]{manifestPlugin.getManifestTaskProvider()}));
    }
}

