/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github.internal;

import io.freefair.gradle.util.GitUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitUtils.class);
    private static final Pattern httpsUrlPattern = Pattern.compile("https://github\\.com/(.+/.+)\\.git");
    private static final Pattern sshUrlPattern = Pattern.compile("git@github.com:(.+/.+)\\.git");

    @Nullable
    public static String findSlug(Project project) {
        if (GitUtil.isGithubActions()) {
            return System.getenv("GITHUB_REPOSITORY");
        }
        String travisSlug = GitUtils.findTravisSlug(project);
        if (travisSlug != null) {
            return travisSlug;
        }
        String remoteUrl = GitUtils.getRemoteUrl(project, "origin");
        Matcher httpsMatcher = httpsUrlPattern.matcher(remoteUrl);
        if (httpsMatcher.matches()) {
            return httpsMatcher.group(1);
        }
        Matcher sshMatcher = sshUrlPattern.matcher(remoteUrl);
        if (sshMatcher.matches()) {
            return sshMatcher.group(1);
        }
        return null;
    }

    @Nullable
    public static String findTravisSlug(Project project) {
        if (GitUtil.isTravisCi()) {
            return System.getenv("TRAVIS_REPO_SLUG");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecResult travisSlugResult = project.exec(execSpec -> {
            execSpec.workingDir((Object)project.getProjectDir());
            execSpec.commandLine(new Object[]{"git", "config", "travis.slug"});
            execSpec.setStandardOutput((OutputStream)outputStream);
            execSpec.setIgnoreExitValue(true);
        });
        if (travisSlugResult.getExitValue() == 0) {
            return outputStream.toString().trim();
        }
        return null;
    }

    public static String getRemoteUrl(Project project, String remote) {
        return GitUtil.execute((Project)project, (String[])new String[]{"git", "ls-remote", "--get-url", remote});
    }

    public static File findWorkingDirectory(Project project) {
        if (GitUtil.isTravisCi()) {
            return new File(System.getenv("TRAVIS_BUILD_DIR"));
        }
        if (GitUtil.isGithubActions()) {
            return new File(System.getenv("GITHUB_WORKSPACE"));
        }
        String git = GitUtil.execute((Project)project, (String[])new String[]{"git", "rev-parse", "--show-toplevel"});
        if (git != null) {
            return new File(git);
        }
        return null;
    }

    public static String getTag(Project project) {
        String githubRef;
        String travisTagEnv;
        if (GitUtil.isTravisCi() && (travisTagEnv = System.getenv("TRAVIS_TAG")) != null && !travisTagEnv.isEmpty()) {
            return travisTagEnv;
        }
        if (GitUtil.isGithubActions() && (githubRef = System.getenv("GITHUB_REF")) != null && githubRef.startsWith("refs/tags/")) {
            return githubRef.substring("refs/tags/".length());
        }
        String gitTag = GitUtil.execute((Project)project, (String[])new String[]{"git", "tag", "--points-at", "HEAD"});
        if (gitTag != null) {
            return gitTag;
        }
        return "HEAD";
    }

    @Nullable
    public static String findGithubUsername(Project project) {
        if (GitUtil.isGithubActions()) {
            return System.getenv("GITHUB_ACTOR");
        }
        Object githubUsername = project.findProperty("githubUsername");
        if (githubUsername != null) {
            return githubUsername.toString();
        }
        return null;
    }

    @Nullable
    public static String findGithubToken(Project project) {
        String github_token = System.getenv("GITHUB_TOKEN");
        if (github_token != null) {
            return github_token;
        }
        Object githubToken = project.findProperty("githubToken");
        if (githubToken != null) {
            return githubToken.toString();
        }
        return null;
    }

    @Generated
    private GitUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

