/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github;

import io.freefair.gradle.plugins.github.GithubExtension;
import io.freefair.gradle.plugins.github.internal.GitUtils;
import io.freefair.gradle.plugins.github.internal.GithubClient;
import io.freefair.gradle.util.GitUtil;
import java.io.File;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class GithubBasePlugin
implements Plugin<Project> {
    private GithubExtension githubExtension;
    private GithubClient githubClient;
    private Project project;

    public void apply(Project project) {
        this.project = project;
        if (project != project.getRootProject()) {
            project.getLogger().warn("This plugin should only be applied to the root project");
        }
        this.githubExtension = (GithubExtension)project.getExtensions().create("github", GithubExtension.class, new Object[0]);
        this.githubExtension.getSlug().convention(project.provider(() -> GitUtils.findSlug(project)));
        this.githubExtension.getTravis().convention(project.provider(this::isTravis));
        this.githubExtension.getTag().convention(project.provider(() -> GitUtils.getTag(project)));
        this.githubExtension.getUsername().convention(project.provider(() -> GitUtils.findGithubUsername(project)));
        this.githubExtension.getToken().convention(project.provider(() -> GitUtils.findGithubToken(project)));
        this.githubClient = new GithubClient(this.githubExtension, new OkHttpClient.Builder().build());
    }

    private boolean isTravis() {
        if (GitUtil.isTravisCi()) {
            return true;
        }
        if (GitUtil.isGithubActions()) {
            return false;
        }
        return new File(GitUtils.findWorkingDirectory(this.project), ".travis.yml").isFile();
    }

    @Generated
    public GithubExtension getGithubExtension() {
        return this.githubExtension;
    }

    @Generated
    public GithubClient getGithubClient() {
        return this.githubClient;
    }
}

