/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github.dependencies;

import com.github.packageurl.PackageURLBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.freefair.gradle.plugins.github.internal.GitUtils;
import io.freefair.gradle.plugins.github.internal.Manifest;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.internal.DefaultGradleVersion;
import org.jetbrains.annotations.NotNull;

public abstract class DependencyManifestTask
extends DefaultTask {
    private transient Manifest manifest;

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract ListProperty<ResolvedComponentResult> getDevelopmentClasspaths();

    @Input
    public abstract ListProperty<ResolvedComponentResult> getRuntimeClasspaths();

    @Input
    public abstract Property<String> getManifestName();

    @Input
    public abstract Property<String> getManifestFileSourceLocation();

    public void configureDefaults(Project project) {
        this.getManifestName().convention((Object)project.getPath());
        File gitDir = GitUtils.findWorkingDirectory(this.getProject());
        String filePath = project.getBuildFile().getCanonicalPath().replace(gitDir.getCanonicalPath(), "");
        if (filePath.startsWith(File.separator)) {
            filePath = filePath.substring(1);
        }
        this.getManifestFileSourceLocation().convention((Object)filePath);
    }

    @TaskAction
    public void writeManifest() throws IOException {
        this.manifest = new Manifest();
        this.manifest.setName((String)this.getManifestName().get());
        this.manifest.setFile(new Manifest.File((String)this.getManifestFileSourceLocation().get()));
        this.addGradleDependency();
        for (ResolvedComponentResult developmentClasspath : (List)this.getDevelopmentClasspaths().get()) {
            developmentClasspath.getDependencies().stream().filter(dep -> !dep.isConstraint()).filter(ResolvedDependencyResult.class::isInstance).map(ResolvedDependencyResult.class::cast).map(resolvedDependencyResult -> this.getGithubDependency(resolvedDependencyResult.getSelected(), "development")).forEach(dep -> dep.setRelationship("direct"));
        }
        for (ResolvedComponentResult runtimeClasspath : (List)this.getRuntimeClasspaths().get()) {
            runtimeClasspath.getDependencies().stream().filter(dep -> !dep.isConstraint()).filter(ResolvedDependencyResult.class::isInstance).map(ResolvedDependencyResult.class::cast).map(d -> this.getGithubDependency(d.getSelected(), "runtime")).forEach(dep -> dep.setRelationship("direct"));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this.manifest);
        Files.write(((File)this.getOutputFile().getAsFile().get()).toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void addGradleDependency() {
        Manifest.Dependency gradleDep = new Manifest.Dependency(this.getPackageUrl(DefaultGradleVersion.current()));
        gradleDep.setScope("development");
        gradleDep.setRelationship("direct");
        this.manifest.getResolved().put(gradleDep.getPackage_url(), gradleDep);
    }

    @NotNull
    private Manifest.Dependency getGithubDependency(ResolvedComponentResult componentResult, String scope) {
        String packageUrl = this.getPackageUrl(componentResult);
        Manifest.Dependency githubDep = this.manifest.getResolved().computeIfAbsent(packageUrl, Manifest.Dependency::new);
        githubDep.setRelationship("indirect");
        githubDep.setScope(scope);
        List<String> collect = componentResult.getDependencies().stream().filter(dep -> !dep.isConstraint()).filter(ResolvedDependencyResult.class::isInstance).map(ResolvedDependencyResult.class::cast).map(d -> this.getGithubDependency(d.getSelected(), scope)).map(Manifest.Dependency::getPackage_url).collect(Collectors.toList());
        githubDep.setDependencies(collect);
        return githubDep;
    }

    private String getPackageUrl(ResolvedComponentResult selected) {
        return PackageURLBuilder.aPackageURL().withType("maven").withNamespace(selected.getModuleVersion().getGroup()).withName(selected.getModuleVersion().getName()).withVersion(selected.getModuleVersion().getVersion()).build().toString();
    }

    private String getPackageUrl(DefaultGradleVersion gradleVersion) {
        return PackageURLBuilder.aPackageURL().withType("github").withNamespace("gradle").withName("gradle").withVersion(gradleVersion.getGitRevision()).build().toString();
    }
}

