/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.github;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public abstract class GithubExtension {
    private static final Pattern slugPattern = Pattern.compile("(.*)/(.*)");

    public abstract Property<String> getSlug();

    public abstract Property<String> getUsername();

    public abstract Property<String> getToken();

    public abstract Property<String> getTag();

    public abstract Property<Boolean> getTravis();

    public GithubExtension() {
        this.getTag().convention((Object)"HEAD");
        this.getTravis().convention((Object)false);
    }

    public Provider<String> getOwner() {
        return this.getSlug().map(sl -> {
            Matcher matcher = slugPattern.matcher((CharSequence)sl);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        });
    }

    public void setOwner(String owner) {
        this.getSlug().set((Object)(owner + "/" + (String)this.getRepo().getOrElse((Object)"")));
    }

    public Provider<String> getRepo() {
        return this.getSlug().map(sl -> {
            Matcher matcher = slugPattern.matcher((CharSequence)sl);
            if (matcher.matches()) {
                return matcher.group(2);
            }
            return null;
        });
    }

    public void setRepo(String repo) {
        this.getSlug().set((Object)((String)this.getOwner().getOrElse((Object)"") + "/" + repo));
    }
}

