/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokJarTask;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.process.ExecOperations;

@NonNullApi
@CacheableTask
public class LombokRuntimeJar
extends LombokJarTask {
    private final ExecOperations execOperations;
    @Console
    private final Property<Boolean> print = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    private final Property<Boolean> create = this.getProject().getObjects().property(Boolean.class).convention((Object)true);

    @Inject
    public LombokRuntimeJar(ExecOperations execOperations) {
        this.execOperations = execOperations;
        this.getArchiveAppendix().convention((Object)"runtime");
    }

    public void copy() {
        this.execOperations.javaexec(runtimeJar -> {
            runtimeJar.setClasspath((FileCollection)this.getLombokClasspath());
            runtimeJar.getMainClass().set((Object)"lombok.launch.Main");
            runtimeJar.args(new Object[]{"createRuntime"});
            if (((Boolean)this.print.get()).booleanValue()) {
                runtimeJar.args(new Object[]{"--print"});
            }
            if (((Boolean)this.create.get()).booleanValue()) {
                runtimeJar.args(new Object[]{"--create"});
                runtimeJar.args(new Object[]{"--output=" + ((RegularFile)this.getArchiveFile().get()).getAsFile().getAbsolutePath()});
            }
        });
    }

    @Generated
    public Property<Boolean> getPrint() {
        return this.print;
    }

    @Generated
    public Property<Boolean> getCreate() {
        return this.create;
    }
}

