/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;

@CacheableTask
public class PostCompile
extends DefaultTask
implements LombokTask {
    private final ExecOperations execOperations;
    @Classpath
    private final ConfigurableFileCollection lombokClasspath = this.getProject().files(new Object[0]);
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    private final ConfigurableFileCollection classFiles = this.getProject().files(new Object[0]);
    @Console
    private final Property<Boolean> verbose = this.getProject().getObjects().property(Boolean.class).convention((Object)false);

    @Inject
    public PostCompile(ExecOperations execOperations) {
        this.execOperations = execOperations;
    }

    @TaskAction
    public void postCompile() {
        this.execOperations.javaexec(postCompile -> {
            postCompile.setClasspath((FileCollection)this.getLombokClasspath());
            postCompile.getMainClass().set((Object)"lombok.launch.Main");
            postCompile.args(new Object[]{"post-compile"});
            if (((Boolean)this.verbose.get()).booleanValue()) {
                postCompile.args(new Object[]{"--verbose"});
            }
            this.classFiles.forEach(file -> postCompile.args(new Object[]{file.getAbsolutePath()}));
        });
    }

    @Override
    @Generated
    public ConfigurableFileCollection getLombokClasspath() {
        return this.lombokClasspath;
    }

    @Generated
    public ConfigurableFileCollection getClassFiles() {
        return this.classFiles;
    }

    @Generated
    public Property<Boolean> getVerbose() {
        return this.verbose;
    }
}

