/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import io.freefair.gradle.plugins.lombok.tasks.internal.LombokConfigAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkerExecutor;

@UntrackedTask(because="lombok config bubbling traverses the file system")
public class LombokConfig
extends DefaultTask
implements LombokTask {
    private final WorkerExecutor workerExecutor;
    private final FileSystemOperations fileSystemOperations;
    private final ExecOperations execOperations;
    @Nested
    @Optional
    private final Property<JavaLauncher> launcher = this.getProject().getObjects().property(JavaLauncher.class);
    @Classpath
    private final ConfigurableFileCollection lombokClasspath = this.getProject().files(new Object[0]);
    @Input
    private final Property<Boolean> generate = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    private final Property<Boolean> verbose = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    private final Property<Boolean> notMentioned = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    @Optional
    private final ListProperty<String> keys = this.getProject().getObjects().listProperty(String.class);
    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    private final ConfigurableFileCollection paths = this.getProject().getObjects().fileCollection();
    @OutputFile
    private final RegularFileProperty outputFile = this.getProject().getObjects().fileProperty();
    @Input
    @Optional
    private final Property<Boolean> fork = this.getProject().getObjects().property(Boolean.class);

    @Inject
    public LombokConfig(WorkerExecutor workerExecutor, FileSystemOperations fileSystemOperations, ExecOperations execOperations) {
        this.workerExecutor = workerExecutor;
        this.fileSystemOperations = fileSystemOperations;
        this.execOperations = execOperations;
        this.getOutputs().upToDateWhen(t -> ((LombokConfig)t).getPaths().isEmpty());
    }

    @TaskAction
    public void exec() throws IOException {
        this.fileSystemOperations.delete(spec -> spec.delete(new Object[]{this.outputFile}).setFollowSymlinks(false));
        List actualPaths = this.paths.getFiles().stream().filter(File::exists).collect(Collectors.toList());
        if (actualPaths.isEmpty() && !((Boolean)this.generate.get()).booleanValue()) {
            ((RegularFile)this.outputFile.get()).getAsFile().createNewFile();
            return;
        }
        LinkedList<String> args = new LinkedList<String>();
        if (((Boolean)this.generate.getOrElse((Object)false)).booleanValue()) {
            args.add("--generate");
        }
        if (((Boolean)this.verbose.getOrElse((Object)false)).booleanValue()) {
            args.add("--verbose");
        }
        if (((Boolean)this.notMentioned.getOrElse((Object)false)).booleanValue()) {
            args.add("--not-mentioned");
        }
        for (String key : (List)this.keys.getOrElse(Collections.emptyList())) {
            args.add("--key=" + key.trim());
        }
        for (File path : actualPaths) {
            args.add(path.getAbsolutePath());
        }
        if (((Boolean)this.fork.getOrElse((Object)false)).booleanValue()) {
            try (FileOutputStream out = new FileOutputStream((File)this.outputFile.getAsFile().get());){
                this.execOperations.javaexec(config -> {
                    if (this.launcher.isPresent()) {
                        config.setExecutable(((JavaLauncher)this.launcher.get()).getExecutablePath().getAsFile().getAbsolutePath());
                    }
                    config.setClasspath((FileCollection)this.getLombokClasspath());
                    config.setMaxHeapSize("16M");
                    config.getMainClass().set((Object)"lombok.launch.Main");
                    config.args(new Object[]{"config"});
                    config.setStandardOutput(out);
                    config.args((Iterable)args);
                });
            }
        } else {
            this.workerExecutor.classLoaderIsolation(cl -> cl.getClasspath().from(new Object[]{this.lombokClasspath})).submit(LombokConfigAction.class, params -> {
                params.getArgs().set((Iterable)args);
                params.getOutputFile().set((Provider)this.outputFile);
            });
        }
    }

    @Override
    @Generated
    public Property<JavaLauncher> getLauncher() {
        return this.launcher;
    }

    @Override
    @Generated
    public ConfigurableFileCollection getLombokClasspath() {
        return this.lombokClasspath;
    }

    @Generated
    public Property<Boolean> getGenerate() {
        return this.generate;
    }

    @Generated
    public Property<Boolean> getVerbose() {
        return this.verbose;
    }

    @Generated
    public Property<Boolean> getNotMentioned() {
        return this.notMentioned;
    }

    @Generated
    public ListProperty<String> getKeys() {
        return this.keys;
    }

    @Generated
    public ConfigurableFileCollection getPaths() {
        return this.paths;
    }

    @Generated
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Generated
    public Property<Boolean> getFork() {
        return this.fork;
    }
}

