/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.plugin.wrappers;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class MavenProjectWrapper
extends MavenProject {
    private final ProjectLayout projectLayout;
    private final File pomFile;
    private final SourceSet main;
    private final SourceSet test;

    public MavenProjectWrapper(ProjectLayout projectLayout, SourceSetContainer sourceSets, File pomFile) throws IOException, XmlPullParserException {
        this.projectLayout = projectLayout;
        this.pomFile = pomFile;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((Reader)new FileReader(pomFile));
        this.setModel(model);
        this.getBuild().setDirectory(((Directory)projectLayout.getBuildDirectory().get()).getAsFile().getAbsolutePath());
        this.main = (SourceSet)sourceSets.getByName("main");
        this.getBuild().setSourceDirectory(((File)this.main.getJava().getSrcDirs().iterator().next()).getAbsolutePath());
        this.getBuild().setOutputDirectory(((Directory)this.main.getJava().getClassesDirectory().get()).getAsFile().getAbsolutePath());
        this.test = (SourceSet)sourceSets.getByName("test");
        this.getBuild().setTestSourceDirectory(((File)this.test.getJava().getSrcDirs().iterator().next()).getAbsolutePath());
        this.getBuild().setTestOutputDirectory(((Directory)this.test.getJava().getClassesDirectory().get()).getAsFile().getAbsolutePath());
        this.setArtifact((Artifact)new ProjectArtifact((MavenProject)this));
    }

    public File getFile() {
        return this.pomFile;
    }

    public File getBasedir() {
        return this.projectLayout.getProjectDirectory().getAsFile();
    }

    public List<String> getCompileSourceRoots() {
        return this.main.getJava().getSrcDirs().stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }

    public List<String> getTestCompileSourceRoots() {
        return this.test.getJava().getSrcDirs().stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }
}

