/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.plugin;

import io.freefair.gradle.plugins.maven.plugin.wrappers.MavenProjectWrapper;
import io.freefair.gradle.plugins.maven.plugin.wrappers.MojoAnnotationScannerWrapper;
import io.freefair.gradle.plugins.maven.plugin.wrappers.PlexusLoggerWrapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.annotations.JavaAnnotationsMojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.DefaultMojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.scanner.DefaultMojoScanner;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.archiver.manager.DefaultArchiverManager;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractGeneratorTask
extends DefaultTask {
    private final ProjectLayout projectLayout;
    @InputFiles
    private final ConfigurableFileCollection sourceDirectories = this.getProject().files(new Object[0]);
    @InputFiles
    private final ConfigurableFileCollection classesDirectories = this.getProject().files(new Object[0]);
    @InputFile
    private final RegularFileProperty pomFile = this.getProject().getObjects().fileProperty();
    @Optional
    @Input
    private final Property<String> encoding = this.getProject().getObjects().property(String.class);
    @Optional
    @Input
    private final Property<String> goalPrefix = this.getProject().getObjects().property(String.class);
    @Input
    private final Property<Boolean> skipErrorNoDescriptorsFound = this.getProject().getObjects().property(Boolean.class).convention((Object)false);

    protected AbstractGeneratorTask(ProjectLayout projectLayout) {
        this.projectLayout = projectLayout;
    }

    @TaskAction
    public void generate() throws GeneratorException, IOException, XmlPullParserException, InvalidPluginDescriptorException, ExtractionException {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        SourceSetContainer sourceSets = ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
        MavenProjectWrapper project = new MavenProjectWrapper(this.projectLayout, sourceSets, (File)this.getPomFile().getAsFile().get());
        pluginDescriptor.setName(project.getName());
        pluginDescriptor.setDescription(project.getDescription());
        pluginDescriptor.setGroupId(project.getGroupId());
        pluginDescriptor.setVersion(project.getVersion());
        pluginDescriptor.setArtifactId(project.getArtifactId());
        pluginDescriptor.setGoalPrefix((String)this.goalPrefix.getOrElse((Object)PluginDescriptor.getGoalPrefixFromArtifactId((String)project.getArtifactId())));
        List<ComponentDependency> deps = this.getRuntimeDependencies();
        pluginDescriptor.setDependencies(deps);
        DefaultPluginToolsRequest request = new DefaultPluginToolsRequest((MavenProject)project, pluginDescriptor);
        if (this.getEncoding().isPresent()) {
            request.setEncoding((String)this.getEncoding().getOrNull());
        }
        request.setSkipErrorNoDescriptorsFound(((Boolean)this.getSkipErrorNoDescriptorsFound().get()).booleanValue());
        MojoScanner mojoScanner = this.getMojoScanner();
        mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
        this.getBaseDir().mkdirs();
        this.getGenerator().execute(this.getBaseDir(), (PluginToolsRequest)request);
    }

    @Nonnull
    private List<ComponentDependency> getRuntimeDependencies() {
        return this.getProject().getConfigurations().getByName("runtimeClasspath").getResolvedConfiguration().getResolvedArtifacts().stream().map(resolvedDependency -> {
            ComponentDependency componentDependency = new ComponentDependency();
            componentDependency.setArtifactId(resolvedDependency.getModuleVersion().getId().getName());
            componentDependency.setGroupId(resolvedDependency.getModuleVersion().getId().getGroup());
            componentDependency.setVersion(resolvedDependency.getModuleVersion().getId().getVersion());
            componentDependency.setType(resolvedDependency.getType());
            return componentDependency;
        }).collect(Collectors.toList());
    }

    @Internal
    protected abstract Generator getGenerator();

    @Internal
    protected abstract File getBaseDir();

    private MojoScanner getMojoScanner() {
        TreeMap<String, JavaAnnotationsMojoDescriptorExtractor> extractors = new TreeMap<String, JavaAnnotationsMojoDescriptorExtractor>();
        extractors.put("java-annotations", this.getMojoDescriptorExtractor());
        DefaultMojoScanner defaultMojoScanner = new DefaultMojoScanner(extractors);
        defaultMojoScanner.enableLogging((Logger)new PlexusLoggerWrapper(this.getLogger()));
        return defaultMojoScanner;
    }

    private JavaAnnotationsMojoDescriptorExtractor getMojoDescriptorExtractor() {
        PlexusLoggerWrapper plexusLoggerWrapper = new PlexusLoggerWrapper(this.getLogger());
        JavaAnnotationsMojoDescriptorExtractor mojoDescriptorExtractor = new JavaAnnotationsMojoDescriptorExtractor();
        mojoDescriptorExtractor.enableLogging((Logger)plexusLoggerWrapper);
        DefaultMojoAnnotationsScanner delegate = new DefaultMojoAnnotationsScanner();
        delegate.enableLogging((Logger)plexusLoggerWrapper);
        MojoAnnotationScannerWrapper mojoAnnotationsScanner = new MojoAnnotationScannerWrapper((MojoAnnotationsScanner)delegate);
        mojoAnnotationsScanner.setSourceDirectories((FileCollection)this.sourceDirectories);
        mojoAnnotationsScanner.setClassesDirectories((FileCollection)this.classesDirectories);
        DefaultArchiverManager archiverManager = new DefaultArchiverManager();
        HashMap<String, MojoAnnotationScannerWrapper> values = new HashMap<String, MojoAnnotationScannerWrapper>();
        values.put("mojoAnnotationsScanner", mojoAnnotationsScanner);
        values.put("archiverManager", (MojoAnnotationScannerWrapper)archiverManager);
        try {
            Class<JavaAnnotationsMojoDescriptorExtractor> clazz = JavaAnnotationsMojoDescriptorExtractor.class;
            for (Map.Entry entry : values.entrySet()) {
                Field declaredField = clazz.getDeclaredField((String)entry.getKey());
                declaredField.setAccessible(true);
                declaredField.set(mojoDescriptorExtractor, entry.getValue());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return mojoDescriptorExtractor;
    }

    @Generated
    public ConfigurableFileCollection getSourceDirectories() {
        return this.sourceDirectories;
    }

    @Generated
    public ConfigurableFileCollection getClassesDirectories() {
        return this.classesDirectories;
    }

    @Generated
    public RegularFileProperty getPomFile() {
        return this.pomFile;
    }

    @Generated
    public Property<String> getEncoding() {
        return this.encoding;
    }

    @Generated
    public Property<String> getGoalPrefix() {
        return this.goalPrefix;
    }

    @Generated
    public Property<Boolean> getSkipErrorNoDescriptorsFound() {
        return this.skipErrorNoDescriptorsFound;
    }
}

