/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.plugin;

import io.freefair.gradle.plugins.maven.plugin.AbstractGeneratorTask;
import io.freefair.gradle.plugins.maven.plugin.internal.MavenHelper;
import io.freefair.gradle.plugins.maven.plugin.wrappers.MavenProjectWrapper;
import io.freefair.gradle.plugins.maven.plugin.wrappers.MojoAnnotationScannerWrapper;
import io.freefair.gradle.plugins.maven.plugin.wrappers.PlexusLoggerWrapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.annotations.JavaAnnotationsMojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.annotations.converter.JavadocBlockTagsToXhtmlConverter;
import org.apache.maven.tools.plugin.extractor.annotations.converter.JavadocInlineTagsToXhtmlConverter;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.DefaultMojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.PluginDescriptorFilesGenerator;
import org.apache.maven.tools.plugin.scanner.DefaultMojoScanner;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSetContainer;

public abstract class DescriptorGeneratorTask
extends AbstractGeneratorTask {
    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @InputFiles
    public abstract ConfigurableFileCollection getSourceDirectories();

    @InputFiles
    public abstract ConfigurableFileCollection getClassesDirectories();

    @InputFile
    public abstract RegularFileProperty getPomFile();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Optional
    @Input
    public abstract Property<String> getEncoding();

    @Input
    public abstract Property<Boolean> getSkipErrorNoDescriptorsFound();

    public DescriptorGeneratorTask() {
        this.getSkipErrorNoDescriptorsFound().convention((Object)false);
    }

    @Override
    protected void generate() throws ExtractionException, InvalidPluginDescriptorException, XmlPullParserException, IOException, GeneratorException {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        SourceSetContainer sourceSets = ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
        MavenProjectWrapper project = new MavenProjectWrapper(this.getProjectLayout(), sourceSets, (File)this.getPomFile().getAsFile().get());
        pluginDescriptor.setGroupId(project.getGroupId());
        pluginDescriptor.setArtifactId(project.getArtifactId());
        pluginDescriptor.setVersion(project.getVersion());
        pluginDescriptor.setGoalPrefix((String)this.getGoalPrefix().getOrElse((Object)PluginDescriptor.getGoalPrefixFromArtifactId((String)project.getArtifactId())));
        pluginDescriptor.setName(project.getName());
        pluginDescriptor.setDescription(project.getDescription());
        List<ComponentDependency> deps = this.getRuntimeDependencies();
        pluginDescriptor.setDependencies(deps);
        DefaultPluginToolsRequest request = new DefaultPluginToolsRequest((MavenProject)project, pluginDescriptor);
        if (this.getEncoding().isPresent()) {
            request.setEncoding((String)this.getEncoding().getOrNull());
        }
        request.setSkipErrorNoDescriptorsFound(((Boolean)this.getSkipErrorNoDescriptorsFound().get()).booleanValue());
        MojoScanner mojoScanner = this.getMojoScanner();
        mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
        PluginDescriptorFilesGenerator pluginDescriptorGenerator = new PluginDescriptorFilesGenerator();
        pluginDescriptorGenerator.execute(((Directory)this.getOutputDirectory().dir("META-INF/maven").get()).getAsFile(), (PluginToolsRequest)request);
    }

    @Nonnull
    private List<ComponentDependency> getRuntimeDependencies() {
        return this.getProject().getConfigurations().getByName("runtimeClasspath").getResolvedConfiguration().getResolvedArtifacts().stream().map(resolvedDependency -> {
            ComponentDependency componentDependency = new ComponentDependency();
            componentDependency.setArtifactId(resolvedDependency.getModuleVersion().getId().getName());
            componentDependency.setGroupId(resolvedDependency.getModuleVersion().getId().getGroup());
            componentDependency.setVersion(resolvedDependency.getModuleVersion().getId().getVersion());
            componentDependency.setType(resolvedDependency.getType());
            return componentDependency;
        }).collect(Collectors.toList());
    }

    private MojoScanner getMojoScanner() {
        TreeMap<String, JavaAnnotationsMojoDescriptorExtractor> extractors = new TreeMap<String, JavaAnnotationsMojoDescriptorExtractor>();
        extractors.put("java-annotations", this.getMojoDescriptorExtractor());
        DefaultMojoScanner defaultMojoScanner = new DefaultMojoScanner(extractors);
        defaultMojoScanner.enableLogging((Logger)new PlexusLoggerWrapper(this.getLogger()));
        return defaultMojoScanner;
    }

    private JavaAnnotationsMojoDescriptorExtractor getMojoDescriptorExtractor() {
        PlexusLoggerWrapper plexusLoggerWrapper = new PlexusLoggerWrapper(this.getLogger());
        JavaAnnotationsMojoDescriptorExtractor mojoDescriptorExtractor = new JavaAnnotationsMojoDescriptorExtractor();
        mojoDescriptorExtractor.enableLogging((Logger)plexusLoggerWrapper);
        DefaultMojoAnnotationsScanner delegate = new DefaultMojoAnnotationsScanner();
        delegate.enableLogging((Logger)plexusLoggerWrapper);
        MojoAnnotationScannerWrapper mojoAnnotationsScanner = new MojoAnnotationScannerWrapper((MojoAnnotationsScanner)delegate);
        mojoAnnotationsScanner.setSourceDirectories((FileCollection)this.getSourceDirectories());
        mojoAnnotationsScanner.setClassesDirectories((FileCollection)this.getClassesDirectories());
        JavadocInlineTagsToXhtmlConverter javadocInlineTagsToXhtmlConverter = new JavadocInlineTagsToXhtmlConverter(MavenHelper.getJavadocInlineTagToHtmlConverters());
        JavadocBlockTagsToXhtmlConverter javadocBlockTagsToXhtmlConverter = new JavadocBlockTagsToXhtmlConverter(javadocInlineTagsToXhtmlConverter, MavenHelper.getJavadocBlockTagToHtmlConverters());
        HashMap<String, MojoAnnotationScannerWrapper> values = new HashMap<String, MojoAnnotationScannerWrapper>();
        values.put("mojoAnnotationsScanner", mojoAnnotationsScanner);
        values.put("archiverManager", (MojoAnnotationScannerWrapper)MavenHelper.getArchiverManager());
        values.put("javadocInlineTagsToHtmlConverter", (MojoAnnotationScannerWrapper)javadocInlineTagsToXhtmlConverter);
        values.put("javadocBlockTagsToHtmlConverter", (MojoAnnotationScannerWrapper)javadocBlockTagsToXhtmlConverter);
        try {
            Class<JavaAnnotationsMojoDescriptorExtractor> clazz = JavaAnnotationsMojoDescriptorExtractor.class;
            for (Map.Entry entry : values.entrySet()) {
                Field declaredField = clazz.getDeclaredField((String)entry.getKey());
                declaredField.setAccessible(true);
                declaredField.set(mojoDescriptorExtractor, entry.getValue());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return mojoDescriptorExtractor;
    }
}

