/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.plugin;

import io.freefair.gradle.plugins.maven.MavenPublishJavaPlugin;
import io.freefair.gradle.plugins.maven.plugin.DescriptorGeneratorTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public class MavenPluginPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        MavenPublishJavaPlugin mavenPublishJavaPlugin = (MavenPublishJavaPlugin)project.getPlugins().apply(MavenPublishJavaPlugin.class);
        if (project.getGradle().getGradleVersion().matches("5\\.6(\\.[12])?")) {
            mavenPublishJavaPlugin.getPublication().getPom().withXml(xmlProvider -> xmlProvider.asNode().appendNode((Object)"packaging", (Object)"maven-plugin"));
        } else {
            mavenPublishJavaPlugin.getPublication().getPom().setPackaging("maven-plugin");
        }
        TaskProvider generateMavenPom = project.getTasks().named("generatePomFileForMavenJavaPublication", GenerateMavenPom.class);
        SourceSet main = (SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        TaskProvider descriptorGeneratorTaskProvider = project.getTasks().register("generateMavenPluginDescriptor", DescriptorGeneratorTask.class, generateMavenPluginDescriptor -> {
            generateMavenPluginDescriptor.dependsOn(new Object[]{generateMavenPom});
            generateMavenPluginDescriptor.getPomFile().fileProvider(generateMavenPom.map(GenerateMavenPom::getDestination));
            generateMavenPluginDescriptor.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("generated/resources/maven-plugin-descriptor"));
            generateMavenPluginDescriptor.getSourceDirectories().from(new Object[]{main.getAllJava().getSourceDirectories()});
            JavaCompile javaCompile = (JavaCompile)project.getTasks().getByName(main.getCompileJavaTaskName());
            generateMavenPluginDescriptor.getClassesDirectories().from(new Object[]{javaCompile});
            generateMavenPluginDescriptor.getEncoding().convention((Object)javaCompile.getOptions().getEncoding());
        });
        main.getResources().srcDir((Object)descriptorGeneratorTaskProvider);
    }
}

