/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.war;

import io.freefair.gradle.plugins.maven.war.WarAttachClassesConvention;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;

public class WarAttachClassesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(WarPlugin.class);
        Property attachClasses = project.getObjects().property(Boolean.class).convention((Object)false);
        Property classesClassifier = project.getObjects().property(String.class).convention((Object)"classes");
        WarAttachClassesConvention attachClassesConvention = new WarAttachClassesConvention((Property<Boolean>)attachClasses, (Property<String>)classesClassifier);
        project.getTasks().named("war", War.class, war -> {
            war.getConvention().getPlugins().put("attachClasses", attachClassesConvention);
            war.getExtensions().add("attachClasses", (Object)attachClasses);
            war.getExtensions().add("classesClassifier", (Object)classesClassifier);
        });
        project.afterEvaluate(p -> {
            if (((Boolean)attachClasses.get()).booleanValue()) {
                TaskProvider jar = project.getTasks().named("jar", Jar.class, j -> j.getArchiveClassifier().convention((Provider)classesClassifier));
                project.getArtifacts().add("archives", (Object)jar);
            }
        });
    }
}

