/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.ResolveJavadocLinks;
import io.freefair.gradle.plugins.okhttp.OkHttpPlugin;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;

public class JavadocLinksPlugin
implements Plugin<Project> {
    private Project project;

    public void apply(Project project) {
        this.project = project;
        OkHttpPlugin okHttpPlugin = (OkHttpPlugin)project.getPlugins().apply(OkHttpPlugin.class);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            TaskProvider javadoc = project.getTasks().named("javadoc", Javadoc.class);
            SourceSet main = (SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
            Configuration compileClasspath = project.getConfigurations().getByName(main.getCompileClasspathConfigurationName());
            project.afterEvaluate(p -> {
                compileClasspath.getAllDependencies().withType(ProjectDependency.class).all(projectDependency -> p.evaluationDependsOn(projectDependency.getDependencyProject().getPath()));
                javadoc.configure(jd -> {
                    ResolveJavadocLinks rjd = new ResolveJavadocLinks(okHttpPlugin.getOkHttpClient());
                    rjd.resolveLinks((Javadoc)jd, compileClasspath);
                });
            });
        });
    }

    @Generated
    public Project getProject() {
        return this.project;
    }
}

