/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.AggregateJavadocPlugin;
import io.freefair.gradle.plugins.maven.javadoc.JavadocLinkUtil;
import io.freefair.gradle.plugins.maven.javadoc.ResolveJavadocLinks;
import io.freefair.gradle.plugins.okhttp.OkHttpPlugin;
import lombok.Generated;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;

public class JavadocLinksPlugin
implements Plugin<Project> {
    private Project project;
    private OkHttpPlugin okHttpPlugin;

    public void apply(Project project) {
        this.project = project;
        this.okHttpPlugin = (OkHttpPlugin)project.getPlugins().apply(OkHttpPlugin.class);
        project.getPlugins().withType(AggregateJavadocPlugin.class, ajp -> project.afterEvaluate(p -> {
            this.addJavaSeLink(ajp.getJavadocTask());
            this.addLinks(ajp.getJavadocTask(), ajp.getJavadocClasspath());
        }));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            TaskProvider javadoc = project.getTasks().named("javadoc", Javadoc.class);
            SourceSet main = (SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
            Configuration compileClasspath = project.getConfigurations().getByName(main.getCompileClasspathConfigurationName());
            project.afterEvaluate(p -> {
                this.addJavaSeLink((TaskProvider<Javadoc>)javadoc);
                this.addLinks((TaskProvider<Javadoc>)javadoc, compileClasspath);
            });
        });
    }

    public void addLinks(TaskProvider<Javadoc> javadocTaskProvider, Configuration classpath) {
        TaskProvider resolveJavadocLinks = this.project.getTasks().register("resolveJavadocLinks", ResolveJavadocLinks.class, new Object[]{this.okHttpPlugin.getOkHttpClient()});
        resolveJavadocLinks.configure(rjd -> {
            rjd.getJavadocTool().convention((Provider)((Javadoc)javadocTaskProvider.get()).getJavadocTool());
            rjd.setClasspath(classpath);
        });
        javadocTaskProvider.configure(javadoc -> {
            javadoc.dependsOn(new Object[]{resolveJavadocLinks});
            javadoc.getInputs().file((Object)resolveJavadocLinks.map(ResolveJavadocLinks::getOutputFile)).withPathSensitivity(PathSensitivity.NAME_ONLY);
            MinimalJavadocOptions options = javadoc.getOptions();
            if (options instanceof StandardJavadocDocletOptions) {
                StandardJavadocDocletOptions standardOptions = (StandardJavadocDocletOptions)options;
                standardOptions.linksFile(((RegularFile)((ResolveJavadocLinks)((Object)((Object)resolveJavadocLinks.get()))).getOutputFile().get()).getAsFile());
            }
        });
    }

    private void addJavaSeLink(TaskProvider<Javadoc> javadocTaskProvider) {
        javadocTaskProvider.configure(jd -> {
            JavaVersion javaVersion = JavadocLinkUtil.getJavaVersion(jd);
            String link = JavadocLinkUtil.getJavaSeLink(javaVersion);
            MinimalJavadocOptions options = jd.getOptions();
            if (options instanceof StandardJavadocDocletOptions) {
                ((StandardJavadocDocletOptions)options).links(new String[]{link});
            }
        });
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public OkHttpPlugin getOkHttpPlugin() {
        return this.okHttpPlugin;
    }
}

