/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.JavadocLinkProvider;
import io.freefair.gradle.plugins.maven.javadoc.JavadocLinkUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.gradle.api.DefaultTask;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.internal.JavadocOptionFile;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.util.GradleVersion;

@NonNullApi
@CacheableTask
public abstract class ResolveJavadocLinks
extends DefaultTask {
    private final OkHttpClient okHttpClient;
    private final List<JavadocLinkProvider> javadocLinkProviders;

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Nested
    public abstract Property<JavadocTool> getJavadocTool();

    @Input
    public abstract ListProperty<ComponentArtifactIdentifier> getArtifactIds();

    @Inject
    public ResolveJavadocLinks(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        this.javadocLinkProviders = new ArrayList<JavadocLinkProvider>();
        for (JavadocLinkProvider javadocLinkProvider : ServiceLoader.load(JavadocLinkProvider.class, ((Object)((Object)this)).getClass().getClassLoader())) {
            this.getLogger().info("{}", javadocLinkProvider.getClass());
            this.javadocLinkProviders.add(javadocLinkProvider);
        }
        File temporaryDir = this.getTemporaryDir();
        File file = new File(temporaryDir, "javadoc-links.options");
        this.getOutputFile().set(file);
    }

    @Input
    protected List<String> getLinkProviderNames() {
        return this.javadocLinkProviders.stream().map(javadocLinkProvider -> javadocLinkProvider.getClass().getName()).sorted().collect(Collectors.toList());
    }

    public void setClasspath(Configuration configuration) {
        Provider resolvedArtifacts = configuration.getIncoming().getArtifacts().getResolvedArtifacts();
        this.getArtifactIds().set(resolvedArtifacts.map(artifacts -> artifacts.stream().map(ArtifactResult::getId).collect(Collectors.toList())));
    }

    @TaskAction
    public void resolveLinks() throws IOException {
        Set links = ((Stream)((List)this.getArtifactIds().get()).stream().map(ComponentArtifactIdentifier::getComponentIdentifier).filter(ModuleComponentIdentifier.class::isInstance).map(ModuleComponentIdentifier.class::cast).parallel()).map(this::toJavadocLink).filter(Objects::nonNull).collect(Collectors.toSet());
        if (this.containsGradleApi()) {
            links.add(JavadocLinkUtil.getGradleApiLink(GradleVersion.current()));
        }
        JavadocOptionFile javadocOptionFile = new JavadocOptionFile();
        JavadocOptionFileOption linkOption = javadocOptionFile.addMultilineStringsOption("link");
        linkOption.setValue(links.stream().sorted().collect(Collectors.toList()));
        javadocOptionFile.write((File)this.getOutputFile().getAsFile().get());
    }

    private boolean containsGradleApi() {
        return ((List)this.getArtifactIds().get()).stream().map(ComponentArtifactIdentifier::getComponentIdentifier).filter(componentIdentifier -> componentIdentifier instanceof OpaqueComponentIdentifier).anyMatch(componentIdentifier -> ((OpaqueComponentIdentifier)componentIdentifier).getClassPathNotation() == DependencyFactoryInternal.ClassPathNotation.GRADLE_API);
    }

    @Nullable
    private String toJavadocLink(ModuleComponentIdentifier moduleComponentIdentifier) {
        String version;
        String artifact;
        String group = moduleComponentIdentifier.getGroup();
        String wellKnownLink = this.findWellKnownLink(group, artifact = moduleComponentIdentifier.getModule(), version = moduleComponentIdentifier.getVersion());
        if (wellKnownLink != null) {
            this.getLogger().info("Using well known link '{}' for '{}:{}:{}'", new Object[]{wellKnownLink, group, artifact, version});
            return wellKnownLink;
        }
        String javadocIoLink = String.format("https://www.javadoc.io/doc/%s/%s/%s/", group, artifact, version);
        if (this.checkLink(javadocIoLink)) {
            this.getLogger().info("Using javadoc.io link for '{}:{}:{}'", new Object[]{group, artifact, version});
            return javadocIoLink;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkLink(String link) {
        IOException exception = null;
        Iterator<String> iterator = Arrays.asList("element-list", "package-list").iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (exception == null) return false;
                this.getLogger().warn("Failed to check link {}", (Object)link, exception);
                return false;
            }
            String file = iterator.next();
            Request request = new Request.Builder().url(link + file).get().build();
            try {
                Response response = this.okHttpClient.newCall(request).execute();
                Throwable throwable = null;
                try {
                    if (!response.isSuccessful()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException e) {
                this.getLogger().info("Failed to access {}", (Object)request.url(), (Object)e);
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
                continue;
            }
            break;
        }
    }

    @Nullable
    private String findWellKnownLink(String group, String artifact, String version) {
        for (JavadocLinkProvider javadocLinkProvider : this.javadocLinkProviders) {
            String javadocLink = javadocLinkProvider.getJavadocLink(group, artifact, version);
            if (javadocLink == null) continue;
            return javadocLink;
        }
        if (group.equals("javax") && artifact.equals("javaee-api") && version.matches("[567]\\..*")) {
            return "https://docs.oracle.com/javaee/" + version.substring(0, 1) + "/api/";
        }
        if (group.equals("org.hibernate") && artifact.equals("hibernate-core")) {
            return "https://docs.jboss.org/hibernate/orm/" + version.substring(0, 3) + "/javadocs/";
        }
        if ((group.equals("org.hibernate") || group.equals("org.hibernate.validator")) && artifact.equals("hibernate-validator")) {
            return "https://docs.jboss.org/hibernate/validator/" + version.substring(0, 3) + "/api/";
        }
        if (group.equals("org.primefaces") && artifact.equals("primefaces")) {
            return "https://www.primefaces.org/docs/api/" + version + "/";
        }
        if (group.equals("org.eclipse.jetty")) {
            return "https://www.eclipse.org/jetty/javadoc/" + version + "/";
        }
        if (group.equals("org.ow2.asm")) {
            return "https://asm.ow2.io/javadoc/";
        }
        if (group.equals("org.joinfaces")) {
            return "https://docs.joinfaces.org/" + version + "/api/";
        }
        if (group.equals("org.projectlombok")) {
            return "https://projectlombok.org/api/";
        }
        if (group.equals("org.jetbrains.kotlin")) {
            return "https://kotlinlang.org/api/latest/jvm/stdlib/";
        }
        return null;
    }
}

