/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.central;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;

public abstract class ValidateMavenPom
extends DefaultTask
implements VerificationTask {
    public static final ProblemGroup PROBLEM_GROUP = ProblemGroup.create((String)"validate-maven-pom", (String)"Maven Pom Validation");
    @Input
    private final Property<Boolean> ignoreFailures = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    private boolean errorFound = false;

    @Inject
    public abstract Problems getProblems();

    @InputFile
    public abstract RegularFileProperty getPomFile();

    @TaskAction
    public void check() throws IOException, XmlPullParserException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((Reader)new FileReader((File)this.getPomFile().getAsFile().get()));
        if (this.isEmpty(model.getGroupId())) {
            this.logError("groupId");
        }
        if (this.isEmpty(model.getArtifactId())) {
            this.logError("artifactId");
        }
        if (this.isEmpty(model.getVersion())) {
            this.logError("version");
        }
        if (this.isEmpty(model.getName())) {
            this.logError("name");
        }
        if (this.isEmpty(model.getDescription())) {
            this.logError("description");
        }
        if (this.isEmpty(model.getUrl())) {
            this.logError("url");
        }
        if (this.isEmpty(model.getLicenses())) {
            this.logError("licenses");
        } else {
            model.getLicenses().forEach(license -> {
                if (this.isEmpty(license.getName())) {
                    this.logError("license.name");
                }
                if (this.isEmpty(license.getUrl())) {
                    this.logError("license.url");
                }
            });
        }
        if (this.isEmpty(model.getDevelopers())) {
            this.logError("developers");
        } else {
            model.getDevelopers().forEach(developer -> {
                if (this.isEmpty(developer.getId())) {
                    this.logError("developer.id");
                }
                if (this.isEmpty(developer.getName())) {
                    this.logError("developer.name");
                }
                if (this.isEmpty(developer.getEmail())) {
                    this.logError("developer.email");
                }
            });
        }
        if (model.getScm() == null) {
            this.logError("scm");
        } else {
            if (this.isEmpty(model.getScm().getConnection())) {
                this.logError("scm.connection");
            }
            if (this.isEmpty(model.getScm().getDeveloperConnection())) {
                this.logError("scm.developerConnection");
            }
            if (this.isEmpty(model.getScm().getUrl())) {
                this.logError("scm.url");
            }
        }
        if (this.errorFound && !this.getIgnoreFailures()) {
            throw new GradleException();
        }
    }

    private void logError(String element) {
        this.errorFound = true;
        this.getLogger().error("No {} found in {}", (Object)element, this.getPomFile().getAsFile().get());
        try {
            ProblemId problemId = ProblemId.create((String)"maven-pom", (String)"Missing Element in Maven Pom", (ProblemGroup)PROBLEM_GROUP);
            this.getProblems().getReporter().report(problemId, problemSpec -> {
                problemSpec.fileLocation(((File)this.getPomFile().getAsFile().get()).getPath());
                problemSpec.details("No " + element + " found");
                problemSpec.severity(Severity.ERROR);
            });
        }
        catch (LinkageError e) {
            this.getLogger().info("Incompatible Gradle Version", (Throwable)e);
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures.set((Object)ignoreFailures);
    }

    public boolean getIgnoreFailures() {
        return (Boolean)this.ignoreFailures.get();
    }
}

