/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import lombok.Generated;
import org.gradle.api.JavaVersion;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.util.GradleVersion;

public final class JavadocLinkUtil {
    public static JavaVersion getJavaVersion(Javadoc javadoc) {
        if (javadoc.getJavadocTool().isPresent()) {
            JavaLanguageVersion languageVersion = ((JavadocTool)javadoc.getJavadocTool().get()).getMetadata().getLanguageVersion();
            return JavaVersion.toVersion((Object)languageVersion.asInt());
        }
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)javadoc.getProject().getExtensions().findByType(JavaPluginExtension.class);
        if (javaPluginExtension != null) {
            return javaPluginExtension.getSourceCompatibility();
        }
        return JavaVersion.current();
    }

    public static String getJavaSeLink(JavaVersion javaVersion) {
        if (javaVersion.isJava11Compatible()) {
            return "https://docs.oracle.com/en/java/javase/" + javaVersion.getMajorVersion() + "/docs/api/";
        }
        return "https://docs.oracle.com/javase/" + javaVersion.getMajorVersion() + "/docs/api/";
    }

    public static String getGradleApiLink(GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            gradleVersion = GradleVersion.current();
        }
        return "https://docs.gradle.org/" + gradleVersion.getVersion() + "/javadoc/";
    }

    @Generated
    private JavadocLinkUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

