/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.javadoc;

import io.freefair.gradle.plugins.maven.javadoc.MultiModuleFixAction;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;

public abstract class AggregateJavadocPlugin
implements Plugin<Project> {
    private TaskProvider<Javadoc> javadocTask;
    private Configuration javadocConfiguration;
    private Configuration javadocSources;
    private Configuration javadocClasspath;
    private TaskProvider<Jar> javadocJar;

    @Inject
    public abstract JvmPluginServices getJvmPluginServices();

    public void apply(Project project) {
        project.getPlugins().apply(JavaBasePlugin.class);
        project.getPlugins().withType(JavaPlugin.class, jp -> project.getLogger().warn("The aggregate-javadoc plugin should not be used on a java project"));
        this.createConfigurations(project);
        this.javadocTask = project.getTasks().register("javadoc", Javadoc.class);
        this.javadocTask.configure(jd -> {
            jd.setGroup("documentation");
            jd.source(new Object[]{this.javadocSources});
            jd.include(new String[]{"**/*.java"});
            jd.setClasspath((FileCollection)this.javadocClasspath);
            jd.doFirst((Action)new MultiModuleFixAction());
        });
        this.javadocJar = project.getTasks().register("javadocJar", Jar.class, jar -> {
            jar.setGroup("build");
            jar.from(new Object[]{this.javadocTask});
            jar.getArchiveClassifier().convention((Object)"javadoc");
        });
        project.getArtifacts().add(this.javadocConfiguration.getName(), this.javadocJar);
        this.javadocConfiguration.getOutgoing().getVariants().create("javadocDirectory", dirVariant -> dirVariant.artifact(this.javadocTask, cpa -> cpa.setType("directory")));
    }

    private void createConfigurations(Project project) {
        this.javadocConfiguration = (Configuration)project.getConfigurations().create("javadoc");
        this.javadocConfiguration.setCanBeConsumed(true);
        this.javadocConfiguration.setCanBeResolved(false);
        this.javadocConfiguration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)project.getObjects().named(Category.class, "documentation"));
        this.javadocConfiguration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)project.getObjects().named(Bundling.class, "embedded"));
        this.javadocConfiguration.getAttributes().attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)project.getObjects().named(DocsType.class, "javadoc"));
        this.javadocSources = (Configuration)project.getConfigurations().create("javadocSources");
        this.javadocSources.setTransitive(false);
        this.javadocSources.setCanBeConsumed(false);
        this.javadocSources.setCanBeResolved(true);
        this.javadocSources.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)project.getObjects().named(Category.class, "verification"));
        this.javadocSources.getAttributes().attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)project.getObjects().named(DocsType.class, "sources"));
        this.javadocSources.getAttributes().attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)project.getObjects().named(VerificationType.class, "main-sources"));
        this.javadocSources.extendsFrom(new Configuration[]{this.javadocConfiguration});
        this.javadocClasspath = (Configuration)project.getConfigurations().create("javadocClasspath");
        this.javadocClasspath.setCanBeConsumed(false);
        this.javadocClasspath.setCanBeResolved(true);
        this.getJvmPluginServices().configureAsRuntimeClasspath((HasConfigurableAttributes)this.javadocClasspath);
        this.javadocClasspath.extendsFrom(new Configuration[]{this.javadocConfiguration});
    }

    @Generated
    public TaskProvider<Javadoc> getJavadocTask() {
        return this.javadocTask;
    }

    @Generated
    public Configuration getJavadocConfiguration() {
        return this.javadocConfiguration;
    }

    @Generated
    public Configuration getJavadocSources() {
        return this.javadocSources;
    }

    @Generated
    public Configuration getJavadocClasspath() {
        return this.javadocClasspath;
    }

    @Generated
    public TaskProvider<Jar> getJavadocJar() {
        return this.javadocJar;
    }
}

