/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp;

import io.freefair.gradle.plugins.okhttp.OkHttpCachePlugin;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class OkHttpPlugin
implements Plugin<Project> {
    @Nullable
    private OkHttpClient okHttpClient;
    private OkHttpCachePlugin okHttpCachePlugin;
    private Project project;

    public void apply(Project project) {
        this.project = project;
        this.okHttpCachePlugin = (OkHttpCachePlugin)project.getRootProject().getPlugins().apply(OkHttpCachePlugin.class);
    }

    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().cache(this.okHttpCachePlugin.getCache());
            if (this.project.getGradle().getStartParameter().isOffline()) {
                builder = builder.addInterceptor((Interceptor)new ForceCacheInterceptor());
            }
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)this.project.getLogger()).info(arg_0));
            loggingInterceptor.level(HttpLoggingInterceptor.Level.BASIC);
            builder = builder.addInterceptor((Interceptor)loggingInterceptor);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    private static class ForceCacheInterceptor
    implements Interceptor {
        private ForceCacheInterceptor() {
        }

        @Nonnull
        public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
            Request newRequest = chain.request().newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
            return chain.proceed(newRequest);
        }
    }
}

