/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp.tasks;

import io.freefair.gradle.plugins.okhttp.OkHttpPlugin;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class OkHttpRequestTask
extends DefaultTask {
    @Input
    private final Property<String> url = this.getProject().getObjects().property(String.class);
    @Input
    private final MapProperty<String, String> headers = this.getProject().getObjects().mapProperty(String.class, String.class);
    @Input
    @Optional
    private final Property<String> username = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    private final Property<String> password = this.getProject().getObjects().property(String.class);

    @TaskAction
    public void executeRequest() throws IOException {
        Request request = this.buildRequest(new Request.Builder()).build();
        OkHttpClient client = this.getOkHttpClient();
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            this.handleResponse(response);
        }
    }

    private OkHttpClient getOkHttpClient() {
        OkHttpPlugin plugin = (OkHttpPlugin)this.getProject().getPlugins().findPlugin(OkHttpPlugin.class);
        OkHttpClient client = plugin != null ? plugin.getOkHttpClient() : new OkHttpClient();
        return client;
    }

    public Request.Builder buildRequest(Request.Builder builder) {
        ((Map)this.headers.get()).forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        if (this.username.isPresent() && this.password.isPresent()) {
            builder.header("Authorization", Credentials.basic((String)((String)this.username.get()), (String)((String)this.password.get())));
        }
        if (this.url.isPresent()) {
            builder.url((String)this.url.get());
        }
        return builder;
    }

    public void handleResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            this.getLogger().error("{}: {}", (Object)response.code(), (Object)response.message());
            this.getLogger().error(response.body().string());
            throw new GradleException(response.message());
        }
    }

    @Generated
    public Property<String> getUrl() {
        return this.url;
    }

    @Generated
    public MapProperty<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public Property<String> getUsername() {
        return this.username;
    }

    @Generated
    public Property<String> getPassword() {
        return this.password;
    }
}

