/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp;

import io.freefair.gradle.plugins.okhttp.OkHttpCachePlugin;
import io.freefair.gradle.plugins.okhttp.OkHttpExtension;
import io.freefair.gradle.plugins.okhttp.internal.CacheControlInterceptor;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class OkHttpPlugin
implements Plugin<Project> {
    @Nullable
    private OkHttpClient okHttpClient;
    private OkHttpCachePlugin okHttpCachePlugin;
    private Project project;
    private OkHttpExtension okHttpExtension;

    public void apply(Project project) {
        this.project = project;
        this.okHttpCachePlugin = (OkHttpCachePlugin)project.getRootProject().getPlugins().apply(OkHttpCachePlugin.class);
        this.okHttpExtension = (OkHttpExtension)project.getExtensions().create("okHttp", OkHttpExtension.class, new Object[0]);
        this.okHttpExtension.getLoggingLevel().convention(project.provider(this::getLevel));
    }

    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().cache(this.okHttpCachePlugin.getCache());
            if (this.project.getGradle().getStartParameter().isOffline()) {
                builder = builder.addInterceptor((Interceptor)new CacheControlInterceptor(CacheControl.FORCE_CACHE));
            } else if (this.project.getGradle().getStartParameter().isRefreshDependencies()) {
                builder = builder.addInterceptor((Interceptor)new CacheControlInterceptor(CacheControl.FORCE_NETWORK));
            }
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)this.project.getLogger()).info(arg_0));
            loggingInterceptor.level((HttpLoggingInterceptor.Level)this.okHttpExtension.getLoggingLevel().get());
            builder = builder.addInterceptor((Interceptor)loggingInterceptor);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    private HttpLoggingInterceptor.Level getLevel() {
        if (this.project.getLogger().isTraceEnabled()) {
            return HttpLoggingInterceptor.Level.BODY;
        }
        if (this.project.getLogger().isDebugEnabled()) {
            return HttpLoggingInterceptor.Level.HEADERS;
        }
        if (this.project.getLogger().isInfoEnabled()) {
            return HttpLoggingInterceptor.Level.BASIC;
        }
        return HttpLoggingInterceptor.Level.NONE;
    }
}

