/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp.tasks;

import io.freefair.gradle.plugins.okhttp.OkHttpPlugin;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class OkHttpRequestTask
extends DefaultTask {
    @Input
    public abstract Property<String> getUrl();

    @Input
    public abstract MapProperty<String, String> getHeaders();

    @Input
    @Optional
    public abstract Property<String> getUsername();

    @Input
    @Optional
    public abstract Property<String> getPassword();

    @TaskAction
    public void executeRequest() throws IOException {
        Request request = this.buildRequest(new Request.Builder()).build();
        OkHttpClient client = this.getOkHttpClient();
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            this.handleResponse(response);
        }
    }

    private OkHttpClient getOkHttpClient() {
        OkHttpPlugin plugin = (OkHttpPlugin)this.getProject().getPlugins().findPlugin(OkHttpPlugin.class);
        OkHttpClient client = plugin != null ? plugin.getOkHttpClient() : new OkHttpClient();
        return client;
    }

    public Request.Builder buildRequest(Request.Builder builder) {
        ((Map)this.getHeaders().get()).forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        if (this.getUsername().isPresent() && this.getPassword().isPresent()) {
            builder.header("Authorization", Credentials.basic((String)((String)this.getUsername().get()), (String)((String)this.getPassword().get())));
        }
        if (this.getUrl().isPresent()) {
            builder.url((String)this.getUrl().get());
        }
        return builder;
    }

    public void handleResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            this.getLogger().error("{}: {}", (Object)response.code(), (Object)response.message());
            this.getLogger().error(response.body().string());
            throw new GradleException(response.message());
        }
    }
}

