/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp.internal;

import io.freefair.gradle.plugins.okhttp.internal.ProgressListener;
import io.freefair.gradle.plugins.okhttp.internal.ProgressRequestBody;
import io.freefair.gradle.plugins.okhttp.internal.ProgressResponseBody;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class ProgressInterceptor
implements Interceptor {
    private final ProgressListener progressListener;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestBody requestBody = request.body();
        String requestMethod = request.method();
        if (requestBody != null) {
            ProgressRequestBody newBody = new ProgressRequestBody(requestBody, this.progressListener);
            request = request.newBuilder().method(requestMethod, (RequestBody)newBody).build();
        }
        Response originalResponse = chain.proceed(request);
        return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), this.progressListener)).build();
    }

    @Generated
    public ProgressInterceptor(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

