/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp;

import io.freefair.gradle.plugins.okhttp.OkHttpExtension;
import io.freefair.gradle.plugins.okhttp.tasks.OkHttpTask;
import okhttp3.logging.HttpLoggingInterceptor;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class OkHttpPlugin
implements Plugin<Project> {
    private Project project;
    private OkHttpExtension okHttpExtension;

    public void apply(Project project) {
        this.project = project;
        this.okHttpExtension = (OkHttpExtension)project.getExtensions().create("okHttp", OkHttpExtension.class, new Object[0]);
        this.okHttpExtension.getLoggingLevel().convention(project.provider(this::getLevel));
        project.getTasks().withType(OkHttpTask.class).configureEach(okHttpTask -> okHttpTask.getLoggingLevel().convention(this.okHttpExtension.getLoggingLevel()));
    }

    private HttpLoggingInterceptor.Level getLevel() {
        if (this.project.getLogger().isTraceEnabled()) {
            return HttpLoggingInterceptor.Level.BODY;
        }
        if (this.project.getLogger().isDebugEnabled()) {
            return HttpLoggingInterceptor.Level.HEADERS;
        }
        if (this.project.getLogger().isInfoEnabled()) {
            return HttpLoggingInterceptor.Level.BASIC;
        }
        return HttpLoggingInterceptor.Level.NONE;
    }
}

